/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import androidx.recyclerview.widget.DiffUtil;
import com.getstream.sdk.chat.adapter.ChannelItemPayloadDiff;
import com.getstream.sdk.chat.utils.extensions.ChannelUtils;
import com.getstream.sdk.chat.utils.extensions.MemberUtils;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.ContentUtils;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.ChatDomain;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/getstream/sdk/chat/adapter/ChannelListDiffCallback;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lio/getstream/chat/android/client/models/Channel;", "newList", "currentUser", "Lio/getstream/chat/android/client/models/User;", "(Ljava/util/List;Ljava/util/List;Lio/getstream/chat/android/client/models/User;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "channelLastMessageDatesAreTheSame", "oldChannel", "newChannel", "channelNameIsTheSame", "channelUserReadIsDifferent", "channelUsersAreTheSame", "getChangePayload", "", "getNewListSize", "getOldListSize", "getUserRead", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "channel", "userId", "", "lastMessagesAreTheSame", "unreadCountIsDifferent", "stream-chat-android_release"})
public final class ChannelListDiffCallback
extends DiffUtil.Callback {
    private final List<Channel> oldList;
    private final List<Channel> newList;
    private final User currentUser;

    public int getOldListSize() {
        return this.oldList.size();
    }

    public int getNewListSize() {
        return this.newList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return Intrinsics.areEqual((Object)this.oldList.get(oldItemPosition).getCid(), (Object)this.newList.get(newItemPosition).getCid());
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        block4: {
            block2: {
                Channel newChannel;
                Channel oldChannel;
                block3: {
                    oldChannel = this.oldList.get(oldItemPosition);
                    newChannel = this.newList.get(newItemPosition);
                    if (Intrinsics.areEqual((Object)oldChannel.getCid(), (Object)newChannel.getCid()) ^ true || oldChannel.getUpdatedAt() == null && newChannel.getUpdatedAt() != null) break block2;
                    if (newChannel.getUpdatedAt() == null) break block3;
                    Date date = oldChannel.getUpdatedAt();
                    Intrinsics.checkNotNull((Object)date);
                    long l = date.getTime();
                    Date date2 = newChannel.getUpdatedAt();
                    Intrinsics.checkNotNull((Object)date2);
                    if (l < date2.getTime()) break block2;
                }
                if (!(Intrinsics.areEqual((Object)oldChannel.getExtraData(), (Object)newChannel.getExtraData()) ^ true) && this.lastMessagesAreTheSame(oldChannel, newChannel) && !this.channelUserReadIsDifferent(oldChannel, newChannel) && !this.unreadCountIsDifferent(oldChannel, newChannel)) break block4;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        Channel newChannel;
        Channel oldChannel = this.oldList.get(oldItemPosition);
        boolean bl = !this.lastMessagesAreTheSame(oldChannel, newChannel = this.newList.get(newItemPosition));
        boolean bl2 = this.unreadCountIsDifferent(oldChannel, newChannel);
        boolean bl3 = !this.channelLastMessageDatesAreTheSame(oldChannel, newChannel);
        boolean bl4 = this.channelUserReadIsDifferent(oldChannel, newChannel);
        boolean bl5 = !this.channelUsersAreTheSame(newChannel, oldChannel);
        boolean bl6 = !this.channelNameIsTheSame(newChannel, oldChannel);
        boolean bl7 = bl;
        return new ChannelItemPayloadDiff(bl6, bl5, bl7, bl3, bl4, bl2);
    }

    private final boolean lastMessagesAreTheSame(Channel oldChannel, Channel newChannel) {
        return Intrinsics.areEqual((Object)ChannelUtils.computeLastMessage(oldChannel), (Object)ChannelUtils.computeLastMessage(newChannel));
    }

    private final boolean channelNameIsTheSame(Channel oldChannel, Channel newChannel) {
        return Intrinsics.areEqual((Object)ContentUtils.getName((Channel)oldChannel), (Object)ContentUtils.getName((Channel)newChannel));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean channelUsersAreTheSame(Channel oldChannel, Channel newChannel) {
        List<User> oldUserList = MemberUtils.getOtherUsers(oldChannel.getMembers(), this.currentUser);
        List<User> newUserList = MemberUtils.getOtherUsers(newChannel.getMembers(), this.currentUser);
        if (oldUserList.size() != newUserList.size()) {
            return false;
        }
        if (oldUserList.isEmpty() && newUserList.isEmpty()) {
            return true;
        }
        int n = 0;
        int n2 = ((Collection)oldUserList).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)oldUserList.get((int)i).getId(), (Object)newUserList.get((int)i).getId()) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final boolean channelLastMessageDatesAreTheSame(Channel oldChannel, Channel newChannel) {
        return Intrinsics.areEqual((Object)oldChannel.getLastMessageAt(), (Object)newChannel.getLastMessageAt());
    }

    private final boolean unreadCountIsDifferent(Channel oldChannel, Channel newChannel) {
        return Intrinsics.areEqual((Object)oldChannel.getUnreadCount(), (Object)newChannel.getUnreadCount()) ^ true;
    }

    private final boolean channelUserReadIsDifferent(Channel oldChannel, Channel newChannel) {
        boolean bl;
        ChannelUserRead oldRead = this.getUserRead(oldChannel, this.currentUser.getId());
        ChannelUserRead newRead = this.getUserRead(newChannel, this.currentUser.getId());
        if (oldRead == null || newRead == null) {
            bl = false;
        } else {
            Date date = newRead.getLastRead();
            Intrinsics.checkNotNull((Object)date);
            bl = date.after(oldRead.getLastRead());
        }
        return bl;
    }

    private final ChannelUserRead getUserRead(Channel channel, String userId) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = channel.getRead();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChannelUserRead it = (ChannelUserRead)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserId(), (Object)userId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmOverloads
    public ChannelListDiffCallback(@NotNull List<Channel> oldList, @NotNull List<Channel> newList, @NotNull User currentUser) {
        Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
        Intrinsics.checkNotNullParameter(newList, (String)"newList");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.oldList = oldList;
        this.newList = newList;
        this.currentUser = currentUser;
    }

    public /* synthetic */ ChannelListDiffCallback(List list, List list2, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            user = ChatDomain.Companion.instance().getCurrentUser();
        }
        this(list, list2, user);
    }

    @JvmOverloads
    public ChannelListDiffCallback(@NotNull List<Channel> oldList, @NotNull List<Channel> newList) {
        this(oldList, newList, null, 4, null);
    }
}

