/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.images.ViewExtensionsKt;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.utils.roundedImageView.CircularImageView;
import com.getstream.sdk.chat.view.ReadStateStyle;
import com.getstream.sdk.chat.view.messages.AvatarStyle;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.ContentUtils;
import io.getstream.chat.android.client.models.User;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0003J0\u0010\u0013\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/getstream/sdk/chat/view/ReadStateView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "avatarStyle", "Lcom/getstream/sdk/chat/view/messages/AvatarStyle;", "isIncoming", "", "readStateStyle", "Lcom/getstream/sdk/chat/view/ReadStateStyle;", "reads", "", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "init", "", "setReads", "Companion", "stream-chat-android_release"})
public final class ReadStateView
extends RelativeLayout {
    private ReadStateStyle readStateStyle = defaultReadStateStyle;
    private AvatarStyle avatarStyle = defaultAvatarStyle;
    private boolean isIncoming;
    private List<ChannelUserRead> reads = CollectionsKt.emptyList();
    @Deprecated
    private static final AvatarStyle defaultAvatarStyle;
    @Deprecated
    private static final ReadStateStyle defaultReadStateStyle;
    @NotNull
    private static final Companion Companion;

    public final void setReads(@NotNull List<ChannelUserRead> reads, boolean isIncoming, @NotNull ReadStateStyle readStateStyle, @NotNull AvatarStyle avatarStyle) {
        Intrinsics.checkNotNullParameter(reads, (String)"reads");
        Intrinsics.checkNotNullParameter((Object)readStateStyle, (String)"readStateStyle");
        Intrinsics.checkNotNullParameter((Object)avatarStyle, (String)"avatarStyle");
        this.reads = reads;
        this.readStateStyle = readStateStyle;
        this.avatarStyle = avatarStyle;
        this.isIncoming = isIncoming;
        this.init();
    }

    public static /* synthetic */ void setReads$default(ReadStateView readStateView, List list, boolean bl, ReadStateStyle readStateStyle, AvatarStyle avatarStyle, int n, Object object) {
        if ((n & 4) != 0) {
            readStateStyle = defaultReadStateStyle;
        }
        if ((n & 8) != 0) {
            avatarStyle = defaultAvatarStyle;
        }
        readStateView.setReads(list, bl, readStateStyle, avatarStyle);
    }

    @SuppressLint(value={"ResourceType"})
    private final void init() {
        this.removeAllViews();
        if (!this.readStateStyle.isReadStateEnabled() || this.reads.isEmpty()) {
            return;
        }
        ChatFonts chatFonts = ChatUI.Companion.instance().getFonts();
        User user = this.reads.get(0).getUser();
        String image = ContentUtils.getImage((User)user);
        CircularImageView imageView = new CircularImageView(this.getContext());
        String initials = ContentUtils.getInitials((User)user);
        imageView.setPlaceholder(initials, this.avatarStyle.getAvatarBackgroundColor(), this.readStateStyle.getReadStateText().getColor());
        Typeface typeface = chatFonts.getFont(this.readStateStyle.getReadStateText());
        if (typeface != null) {
            imageView.setPlaceholderTextSize(0, this.readStateStyle.getReadStateText().getSize(), typeface);
        } else {
            imageView.setPlaceholderTextSize(0, this.readStateStyle.getReadStateText().getSize(), this.readStateStyle.getReadStateText().getStyle());
        }
        if (!Utils.isSVGImage((String)image)) {
            ViewExtensionsKt.load$default((ImageView)((ImageView)imageView), (Object)image, null, null, null, null, (int)30, null);
        }
        RelativeLayout.LayoutParams avatarParams = new RelativeLayout.LayoutParams(this.readStateStyle.getReadStateAvatarWidth(), this.readStateStyle.getReadStateAvatarHeight());
        RelativeLayout.LayoutParams textParams = new RelativeLayout.LayoutParams(-2, this.readStateStyle.getReadStateAvatarHeight());
        imageView.setId(1);
        if (this.reads.size() < 2) {
            imageView.setLayoutParams((ViewGroup.LayoutParams)avatarParams);
            this.addView((View)imageView);
            return;
        }
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)String.valueOf(this.reads.size() - 1));
        textView.setTextColor(this.readStateStyle.getReadStateText().getColor());
        textView.setTextSize(0, (float)this.readStateStyle.getReadStateText().getSize());
        chatFonts.setFont(this.readStateStyle.getReadStateText(), textView);
        textView.setGravity(17);
        textView.setId(2);
        if (this.isIncoming) {
            textParams.addRule(1, imageView.getId());
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            textParams.setMarginStart(context.getResources().getDimensionPixelOffset(R.dimen.stream_composer_stroke_width));
        } else {
            avatarParams.addRule(1, textView.getId());
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            avatarParams.setMarginStart(context.getResources().getDimensionPixelOffset(R.dimen.stream_composer_stroke_width));
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)avatarParams);
        textView.setLayoutParams((ViewGroup.LayoutParams)textParams);
        this.addView((View)textView);
        this.addView((View)imageView);
    }

    public ReadStateView(@Nullable Context context) {
        super(context);
        this.init();
    }

    public ReadStateView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    static {
        Companion = new Companion(null);
        defaultAvatarStyle = new AvatarStyle(0, 0, 0, 0, 0, new TextStyle());
        defaultReadStateStyle = new ReadStateStyle(new TextStyle(), false, false, 0, 0);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/getstream/sdk/chat/view/ReadStateView$Companion;", "", "()V", "defaultAvatarStyle", "Lcom/getstream/sdk/chat/view/messages/AvatarStyle;", "defaultReadStateStyle", "Lcom/getstream/sdk/chat/view/ReadStateStyle;", "stream-chat-android_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

