/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat;

import android.content.Context;
import com.getstream.sdk.chat.ChatMarkdown;
import com.getstream.sdk.chat.ChatMarkdownImpl;
import com.getstream.sdk.chat.UrlSigner;
import com.getstream.sdk.chat.navigation.ChatNavigationHandler;
import com.getstream.sdk.chat.navigation.ChatNavigator;
import com.getstream.sdk.chat.navigation.ChatNavigatorImpl;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.style.ChatFontsImpl;
import com.getstream.sdk.chat.style.ChatStyle;
import com.getstream.sdk.chat.utils.strings.ChatStrings;
import com.getstream.sdk.chat.utils.strings.ChatStringsImpl;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.livedata.ChatDomain;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/getstream/sdk/chat/ChatUI;", "", "fonts", "Lcom/getstream/sdk/chat/style/ChatFonts;", "strings", "Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "navigator", "Lcom/getstream/sdk/chat/navigation/ChatNavigator;", "markdown", "Lcom/getstream/sdk/chat/ChatMarkdown;", "urlSigner", "Lcom/getstream/sdk/chat/UrlSigner;", "(Lcom/getstream/sdk/chat/style/ChatFonts;Lcom/getstream/sdk/chat/utils/strings/ChatStrings;Lcom/getstream/sdk/chat/navigation/ChatNavigator;Lcom/getstream/sdk/chat/ChatMarkdown;Lcom/getstream/sdk/chat/UrlSigner;)V", "getFonts", "()Lcom/getstream/sdk/chat/style/ChatFonts;", "getMarkdown", "()Lcom/getstream/sdk/chat/ChatMarkdown;", "getNavigator", "()Lcom/getstream/sdk/chat/navigation/ChatNavigator;", "getStrings", "()Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "getUrlSigner", "()Lcom/getstream/sdk/chat/UrlSigner;", "version", "", "getVersion", "()Ljava/lang/String;", "Builder", "Companion", "stream-chat-android_release"})
public final class ChatUI {
    @NotNull
    private final ChatFonts fonts;
    @NotNull
    private final ChatStrings strings;
    @NotNull
    private final ChatNavigator navigator;
    @NotNull
    private final ChatMarkdown markdown;
    @NotNull
    private final UrlSigner urlSigner;
    private static ChatUI instance;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getVersion() {
        return "release:4.9.1";
    }

    @NotNull
    public final ChatFonts getFonts() {
        return this.fonts;
    }

    @NotNull
    public final ChatStrings getStrings() {
        return this.strings;
    }

    @NotNull
    public final ChatNavigator getNavigator() {
        return this.navigator;
    }

    @NotNull
    public final ChatMarkdown getMarkdown() {
        return this.markdown;
    }

    @NotNull
    public final UrlSigner getUrlSigner() {
        return this.urlSigner;
    }

    public ChatUI(@NotNull ChatFonts fonts, @NotNull ChatStrings strings, @NotNull ChatNavigator navigator, @NotNull ChatMarkdown markdown, @NotNull UrlSigner urlSigner) {
        Intrinsics.checkNotNullParameter((Object)fonts, (String)"fonts");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)urlSigner, (String)"urlSigner");
        this.fonts = fonts;
        this.strings = strings;
        this.navigator = navigator;
        this.markdown = markdown;
        this.urlSigner = urlSigner;
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @NotNull
    public static final ChatUI instance() {
        return Companion.instance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/getstream/sdk/chat/ChatUI$Builder;", "", "client", "Lio/getstream/chat/android/client/ChatClient;", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "appContext", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/livedata/ChatDomain;Landroid/content/Context;)V", "(Landroid/content/Context;)V", "fonts", "Lcom/getstream/sdk/chat/style/ChatFonts;", "markdown", "Lcom/getstream/sdk/chat/ChatMarkdown;", "navigationHandler", "Lcom/getstream/sdk/chat/navigation/ChatNavigationHandler;", "strings", "Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "style", "Lcom/getstream/sdk/chat/style/ChatStyle;", "urlSigner", "Lcom/getstream/sdk/chat/UrlSigner;", "build", "Lcom/getstream/sdk/chat/ChatUI;", "withFonts", "withMarkdown", "withNavigationHandler", "handler", "withStrings", "withStyle", "withUrlSigner", "signer", "stream-chat-android_release"})
    public static final class Builder {
        private ChatStyle style;
        private ChatNavigationHandler navigationHandler;
        private UrlSigner urlSigner;
        private ChatMarkdown markdown;
        private ChatFonts fonts;
        private ChatStrings strings;
        private final Context appContext;

        @NotNull
        public final Builder withStyle(@NotNull ChatStyle style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.style = style;
            return builder;
        }

        @NotNull
        public final Builder withMarkdown(@NotNull ChatMarkdown markdown) {
            Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.markdown = markdown;
            return builder;
        }

        @NotNull
        public final Builder withUrlSigner(@NotNull UrlSigner signer) {
            Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.urlSigner = signer;
            return builder;
        }

        @NotNull
        public final Builder withNavigationHandler(@NotNull ChatNavigationHandler handler) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.navigationHandler = handler;
            return builder;
        }

        @NotNull
        public final Builder withFonts(@NotNull ChatFonts fonts) {
            Intrinsics.checkNotNullParameter((Object)fonts, (String)"fonts");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.fonts = fonts;
            return builder;
        }

        @NotNull
        public final Builder withStrings(@NotNull ChatStrings strings) {
            Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.strings = strings;
            return builder;
        }

        @NotNull
        public final ChatUI build() {
            UrlSigner urlSigner;
            ChatNavigationHandler chatNavigationHandler;
            ChatStrings chatStrings;
            ChatFonts chatFonts;
            ChatStyle chatStyle;
            ChatStyle chatStyle2 = this.style;
            if (chatStyle2 == null) {
                chatStyle2 = chatStyle = new ChatStyle.Builder().build();
            }
            if ((chatFonts = this.fonts) == null) {
                chatFonts = new ChatFontsImpl(chatStyle, this.appContext);
            }
            if ((chatStrings = this.strings) == null) {
                chatStrings = (ChatStrings)new ChatStringsImpl(this.appContext);
            }
            if ((chatNavigationHandler = this.navigationHandler) == null) {
                chatNavigationHandler = ChatNavigatorImpl.EMPTY_HANDLER;
            }
            ChatNavigator chatNavigator = new ChatNavigatorImpl(chatNavigationHandler);
            ChatMarkdown chatMarkdown = this.markdown;
            if (chatMarkdown == null) {
                chatMarkdown = new ChatMarkdownImpl(this.appContext);
            }
            if ((urlSigner = this.urlSigner) == null) {
                urlSigner = (UrlSigner)new UrlSigner.DefaultUrlSigner();
            }
            instance = new ChatUI(chatFonts, chatStrings, chatNavigator, chatMarkdown, urlSigner);
            return Companion.instance();
        }

        public Builder(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            this.appContext = appContext;
        }

        @Deprecated(message="Deprecated constructor, `ChatClient` and `ChatDomain` is not needed anymore to build a `ChatUI` instance", replaceWith=@ReplaceWith(imports={}, expression="ChatUI.Builder(appContext)"), level=DeprecationLevel.ERROR)
        public Builder(@NotNull ChatClient client, @NotNull ChatDomain chatDomain, @NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            this(appContext);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/getstream/sdk/chat/ChatUI$Companion;", "", "()V", "instance", "Lcom/getstream/sdk/chat/ChatUI;", "stream-chat-android_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ChatUI instance() {
            ChatUI chatUI = instance;
            boolean bl = false;
            boolean bl2 = false;
            if (chatUI == null) {
                boolean bl3 = false;
                String string = "Be sure to call ChatUI.Builder().build() before using ChatUI.instance()";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return chatUI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

