/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.lifecycle.LiveData;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;

public class ConnectionLiveData
extends LiveData<ConnectionModel> {
    private TaggedLogger logger = ChatLogger.Companion.get((Object)"ConnectionLiveData");
    private Context context;
    private BroadcastReceiver networkReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getExtras() != null) {
                boolean isConnected;
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager == null) {
                    ConnectionLiveData.this.logger.logE("Can't get access to ConnectivityManager");
                    return;
                }
                NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
                boolean bl = isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
                if (isConnected) {
                    switch (activeNetwork.getType()) {
                        case 1: {
                            ConnectionLiveData.this.postValue(new ConnectionModel(1, true));
                            break;
                        }
                        case 0: {
                            ConnectionLiveData.this.postValue(new ConnectionModel(0, true));
                        }
                    }
                } else {
                    ConnectionLiveData.this.postValue(new ConnectionModel(0, false));
                }
            }
        }
    };

    public ConnectionLiveData(Context context) {
        this.context = context;
    }

    protected void onActive() {
        super.onActive();
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.context.registerReceiver(this.networkReceiver, filter);
    }

    protected void onInactive() {
        super.onInactive();
        this.context.unregisterReceiver(this.networkReceiver);
    }

    public class ConnectionModel {
        private int type;
        private boolean isConnected;

        public ConnectionModel(int type, boolean isConnected) {
            this.type = type;
            this.isConnected = isConnected;
        }

        public int getType() {
            return this.type;
        }

        public boolean getIsConnected() {
            return this.isConnected;
        }
    }
}

