/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.attachment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.getstream.sdk.chat.adapter.AttachmentListItem;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.attachment.BaseAttachmentViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemAttachmentFileBinding;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.UiUtils;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/attachment/AttachmentViewHolderFile;", "Lcom/getstream/sdk/chat/adapter/viewholder/attachment/BaseAttachmentViewHolder;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "clickListener", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "longClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "longClickListenerView", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentFileBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentFileBinding;)V", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "applyStyle", "", "bind", "attachmentListItem", "Lcom/getstream/sdk/chat/adapter/AttachmentListItem;", "configAttachment", "configClickListeners", "stream-chat-android_release"})
public final class AttachmentViewHolderFile
extends BaseAttachmentViewHolder {
    private Attachment attachment;
    private final MessageListViewStyle style;
    private final MessageListView.BubbleHelper bubbleHelper;
    private final MessageListItem.MessageItem messageItem;
    private final MessageListView.AttachmentClickListener clickListener;
    private final MessageListView.MessageLongClickListener longClickListener;
    private final MessageListView.MessageLongClickListenerView longClickListenerView;
    private final StreamItemAttachmentFileBinding binding;

    @Override
    public void bind(@NotNull AttachmentListItem attachmentListItem) {
        Intrinsics.checkNotNullParameter((Object)attachmentListItem, (String)"attachmentListItem");
        this.attachment = attachmentListItem.getAttachment();
        this.applyStyle();
        this.configAttachment();
        this.configClickListeners();
    }

    private final void applyStyle() {
        if (this.messageItem.isMine()) {
            TextStyle textStyle = this.style.getAttachmentTitleTextMine();
            TextView textView = this.binding.tvFileTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileTitle");
            textStyle.apply(textView);
            TextStyle textStyle2 = this.style.getAttachmentFileSizeTextMine();
            TextView textView2 = this.binding.tvFileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.tvFileSize");
            textStyle2.apply(textView2);
        } else {
            TextStyle textStyle = this.style.getAttachmentTitleTextTheirs();
            TextView textView = this.binding.tvFileTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileTitle");
            textStyle.apply(textView);
            TextStyle textStyle3 = this.style.getAttachmentFileSizeTextTheirs();
            TextView textView3 = this.binding.tvFileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.tvFileSize");
            textStyle3.apply(textView3);
        }
    }

    private final void configAttachment() {
        TextView textView = this.binding.tvFileSize;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileSize");
        Attachment attachment = this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
        }
        textView.setText((CharSequence)UiUtils.INSTANCE.getFileSizeHumanized(attachment.getFileSize()));
        ImageView imageView = this.binding.ivFileThumb;
        Attachment attachment2 = this.attachment;
        if (attachment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
        }
        imageView.setImageResource(UiUtils.INSTANCE.getIcon(attachment2.getMimeType()));
        TextView textView2 = this.binding.tvFileTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.tvFileTitle");
        Attachment attachment3 = this.attachment;
        if (attachment3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
        }
        textView2.setText((CharSequence)attachment3.getTitle());
        Message message = this.messageItem.getMessage();
        boolean bl = this.messageItem.isMine();
        List list = this.messageItem.getPositions();
        Attachment attachment4 = this.attachment;
        if (attachment4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
        }
        Drawable background = this.bubbleHelper.getDrawableForAttachment(message, bl, list, attachment4);
        ConstraintLayout constraintLayout = this.binding.attachmentview;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.attachmentview");
        constraintLayout.setBackground(background);
    }

    private final void configClickListeners() {
        this.binding.attachmentview.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ AttachmentViewHolderFile this$0;

            public final void onClick(View it) {
                AttachmentViewHolderFile.access$getClickListener$p(this.this$0).onAttachmentClick(AttachmentViewHolderFile.access$getMessageItem$p(this.this$0).getMessage(), AttachmentViewHolderFile.access$getAttachment$p(this.this$0));
            }
            {
                this.this$0 = attachmentViewHolderFile;
            }
        });
        this.binding.attachmentview.setOnLongClickListener(new View.OnLongClickListener(this){
            final /* synthetic */ AttachmentViewHolderFile this$0;

            public final boolean onLongClick(View it) {
                block1: {
                    block0: {
                        if (AttachmentViewHolderFile.access$getLongClickListenerView$p(this.this$0) == null) break block0;
                        MessageListView.MessageLongClickListenerView messageLongClickListenerView = AttachmentViewHolderFile.access$getLongClickListenerView$p(this.this$0);
                        Message message = AttachmentViewHolderFile.access$getMessageItem$p(this.this$0).getMessage();
                        View view = this.this$0.itemView;
                        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
                        messageLongClickListenerView.onMessageLongClick2(message, view);
                        break block1;
                    }
                    MessageListView.MessageLongClickListener messageLongClickListener2 = AttachmentViewHolderFile.access$getLongClickListener$p(this.this$0);
                    if (messageLongClickListener2 == null) break block1;
                    messageLongClickListener2.onMessageLongClick(AttachmentViewHolderFile.access$getMessageItem$p(this.this$0).getMessage());
                }
                return true;
            }
            {
                this.this$0 = attachmentViewHolderFile;
            }
        });
    }

    public AttachmentViewHolderFile(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListItem.MessageItem messageItem, @NotNull MessageListView.AttachmentClickListener clickListener2, @Nullable MessageListView.MessageLongClickListener longClickListener, @Nullable MessageListView.MessageLongClickListenerView longClickListenerView, @NotNull StreamItemAttachmentFileBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Intrinsics.checkNotNullParameter((Object)clickListener2, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ConstraintLayout constraintLayout = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        super((View)constraintLayout);
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageItem = messageItem;
        this.clickListener = clickListener2;
        this.longClickListener = longClickListener;
        this.longClickListenerView = longClickListenerView;
        this.binding = binding;
    }

    public /* synthetic */ AttachmentViewHolderFile(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, MessageListView.BubbleHelper bubbleHelper, MessageListItem.MessageItem messageItem, MessageListView.AttachmentClickListener attachmentClickListener2, MessageListView.MessageLongClickListener messageLongClickListener2, MessageListView.MessageLongClickListenerView messageLongClickListenerView, StreamItemAttachmentFileBinding streamItemAttachmentFileBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            messageLongClickListenerView = null;
        }
        if ((n & 0x80) != 0) {
            ViewGroup $this$inflater$iv = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"LayoutInflater.from(context)");
            StreamItemAttachmentFileBinding streamItemAttachmentFileBinding2 = StreamItemAttachmentFileBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachmentFileBinding2, (String)"StreamItemAttachmentFile\u2026.inflater, parent, false)");
            streamItemAttachmentFileBinding = streamItemAttachmentFileBinding2;
        }
        this(viewGroup, messageListViewStyle, bubbleHelper, messageItem, attachmentClickListener2, messageLongClickListener2, messageLongClickListenerView, streamItemAttachmentFileBinding);
    }

    public static final /* synthetic */ MessageListView.AttachmentClickListener access$getClickListener$p(AttachmentViewHolderFile $this) {
        return $this.clickListener;
    }

    public static final /* synthetic */ MessageListItem.MessageItem access$getMessageItem$p(AttachmentViewHolderFile $this) {
        return $this.messageItem;
    }

    public static final /* synthetic */ Attachment access$getAttachment$p(AttachmentViewHolderFile $this) {
        Attachment attachment = $this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
        }
        return attachment;
    }

    public static final /* synthetic */ void access$setAttachment$p(AttachmentViewHolderFile $this, Attachment attachment) {
        $this.attachment = attachment;
    }

    public static final /* synthetic */ MessageListView.MessageLongClickListenerView access$getLongClickListenerView$p(AttachmentViewHolderFile $this) {
        return $this.longClickListenerView;
    }

    public static final /* synthetic */ MessageListView.MessageLongClickListener access$getLongClickListener$p(AttachmentViewHolderFile $this) {
        return $this.longClickListener;
    }
}

