/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0012\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\f\u0010\"\u001a\u00020\u001b*\u00020\u001bH\u0002J\u0014\u0010#\u001a\u00020\u0004*\u00020\u00042\u0006\u0010$\u001a\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/getstream/sdk/chat/view/AvatarDrawable;", "Landroid/graphics/drawable/Drawable;", "bitmaps", "", "Landroid/graphics/Bitmap;", "(Ljava/util/List;)V", "avatarBitmaps", "avatarItems", "Lcom/getstream/sdk/chat/view/AvatarDrawable$AvatarItem;", "paint", "Landroid/graphics/Paint;", "configureDoubleAvatar", "topAvatarBitmap", "bottomAvatarBitmap", "configureSingleAvatar", "avatarBitmap", "configureTripleAvatar", "topLeftAvatarBitmap", "topRightAvatarBitmap", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "reconfigureItems", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "reduce", "scaleCenterCrop", "size", "AvatarItem", "stream-chat-android_release"})
final class AvatarDrawable
extends Drawable {
    private final List<Bitmap> avatarBitmaps;
    private final Paint paint;
    private List<AvatarItem> avatarItems;

    private final void reconfigureItems() {
        List<AvatarItem> list;
        switch (this.avatarBitmaps.size()) {
            case 0: {
                boolean bl = false;
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = this.configureSingleAvatar(this.avatarBitmaps.get(0));
                break;
            }
            case 2: {
                list = this.configureDoubleAvatar(this.avatarBitmaps.get(0), this.avatarBitmaps.get(1));
                break;
            }
            default: {
                list = this.configureTripleAvatar(this.avatarBitmaps.get(0), this.avatarBitmaps.get(1), this.avatarBitmaps.get(2));
            }
        }
        this.avatarItems = list;
    }

    private final List<AvatarItem> configureSingleAvatar(Bitmap avatarBitmap) {
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        return CollectionsKt.listOf((Object)new AvatarItem(this.scaleCenterCrop(avatarBitmap, rect), new Rect(0, 0, this.getBounds().width(), this.getBounds().height())));
    }

    private final List<AvatarItem> configureDoubleAvatar(Bitmap topAvatarBitmap, Bitmap bottomAvatarBitmap) {
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect avatarBound = this.reduce(rect);
        return CollectionsKt.listOf((Object[])new AvatarItem[]{new AvatarItem(this.scaleCenterCrop(topAvatarBitmap, avatarBound), avatarBound), new AvatarItem(this.scaleCenterCrop(bottomAvatarBitmap, avatarBound), new Rect(this.getBounds().right - avatarBound.right, this.getBounds().bottom - avatarBound.bottom, this.getBounds().right, this.getBounds().bottom))});
    }

    private final List<AvatarItem> configureTripleAvatar(Bitmap topLeftAvatarBitmap, Bitmap topRightAvatarBitmap, Bitmap bottomAvatarBitmap) {
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect avatarBound = this.reduce(rect);
        return CollectionsKt.listOf((Object[])new AvatarItem[]{new AvatarItem(this.scaleCenterCrop(topLeftAvatarBitmap, avatarBound), avatarBound), new AvatarItem(this.scaleCenterCrop(topRightAvatarBitmap, avatarBound), new Rect(this.getBounds().right - avatarBound.right, 0, this.getBounds().right, avatarBound.bottom)), new AvatarItem(this.scaleCenterCrop(bottomAvatarBitmap, avatarBound), new Rect(this.getBounds().right / 2 - avatarBound.right / 2, this.getBounds().bottom - avatarBound.bottom, this.getBounds().right / 2 + avatarBound.right / 2, this.getBounds().bottom))});
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Iterable $this$forEach$iv = this.avatarItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvatarItem it = (AvatarItem)element$iv;
            boolean bl = false;
            canvas.drawBitmap(it.getBitmap(), this.getBounds(), it.getPosition(), this.paint);
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.onBoundsChange(bounds);
        this.reconfigureItems();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    private final Rect reduce(Rect $this$reduce) {
        return new Rect(0, 0, (int)((double)$this$reduce.width() / 1.7), (int)((double)$this$reduce.height() / 1.7));
    }

    private final Bitmap scaleCenterCrop(Bitmap $this$scaleCenterCrop, Rect size) {
        Bitmap bitmap = ThumbnailUtils.extractThumbnail((Bitmap)$this$scaleCenterCrop, (int)size.width(), (int)size.height());
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"ThumbnailUtils.extractTh\u2026e.width(), size.height())");
        return bitmap;
    }

    public AvatarDrawable(@NotNull List<Bitmap> bitmaps) {
        Intrinsics.checkNotNullParameter(bitmaps, (String)"bitmaps");
        this.avatarBitmaps = CollectionsKt.take((Iterable)bitmaps, (int)3);
        this.paint = new Paint(1);
        boolean bl = false;
        this.avatarItems = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/getstream/sdk/chat/view/AvatarDrawable$AvatarItem;", "", "bitmap", "Landroid/graphics/Bitmap;", "position", "Landroid/graphics/Rect;", "(Landroid/graphics/Bitmap;Landroid/graphics/Rect;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getPosition", "()Landroid/graphics/Rect;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "stream-chat-android_release"})
    private static final class AvatarItem {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Rect position;

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Rect getPosition() {
            return this.position;
        }

        public AvatarItem(@NotNull Bitmap bitmap, @NotNull Rect position) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.bitmap = bitmap;
            this.position = position;
        }

        @NotNull
        public final Bitmap component1() {
            return this.bitmap;
        }

        @NotNull
        public final Rect component2() {
            return this.position;
        }

        @NotNull
        public final AvatarItem copy(@NotNull Bitmap bitmap, @NotNull Rect position) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new AvatarItem(bitmap, position);
        }

        public static /* synthetic */ AvatarItem copy$default(AvatarItem avatarItem, Bitmap bitmap, Rect rect, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = avatarItem.bitmap;
            }
            if ((n & 2) != 0) {
                rect = avatarItem.position;
            }
            return avatarItem.copy(bitmap, rect);
        }

        @NotNull
        public String toString() {
            return "AvatarItem(bitmap=" + this.bitmap + ", position=" + this.position + ")";
        }

        public int hashCode() {
            Bitmap bitmap = this.bitmap;
            Rect rect = this.position;
            return (bitmap != null ? bitmap.hashCode() : 0) * 31 + (rect != null ? rect.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AvatarItem)) break block3;
                    AvatarItem avatarItem = (AvatarItem)object;
                    if (!Intrinsics.areEqual((Object)this.bitmap, (Object)avatarItem.bitmap) || !Intrinsics.areEqual((Object)this.position, (Object)avatarItem.position)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

