/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.DeviceService;
import io.getstream.chat.java.services.framework.StreamServiceGenerator;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Device {
    @JsonProperty(value="push_provider")
    @Nullable
    private PushProvider pushProvider;
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="disabled")
    @Nullable
    private Boolean disabled;
    @JsonProperty(value="disabled_reason")
    @Nullable
    private String disabledReason;
    @JsonProperty(value="user_id")
    @NotNull
    private String userId;

    @NotNull
    public static DeviceCreateRequestData.DeviceCreateRequest create() {
        return new DeviceCreateRequestData.DeviceCreateRequest();
    }

    @NotNull
    public static DeviceDeleteRequest delete(@NotNull String id, @NotNull String userId) {
        return new DeviceDeleteRequest(id, userId);
    }

    @NotNull
    public static DeviceListRequest list(@NotNull String userId) {
        return new DeviceListRequest(userId);
    }

    @Nullable
    public PushProvider getPushProvider() {
        return this.pushProvider;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Nullable
    public String getDisabledReason() {
        return this.disabledReason;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="push_provider")
    public void setPushProvider(@Nullable PushProvider pushProvider) {
        this.pushProvider = pushProvider;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(@Nullable Boolean disabled) {
        this.disabled = disabled;
    }

    @JsonProperty(value="disabled_reason")
    public void setDisabledReason(@Nullable String disabledReason) {
        this.disabledReason = disabledReason;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NotNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        PushProvider this$pushProvider = this.getPushProvider();
        PushProvider other$pushProvider = other.getPushProvider();
        if (this$pushProvider == null ? other$pushProvider != null : !((Object)((Object)this$pushProvider)).equals((Object)other$pushProvider)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$disabledReason = this.getDisabledReason();
        String other$disabledReason = other.getDisabledReason();
        if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        PushProvider $pushProvider = this.getPushProvider();
        result = result * 59 + ($pushProvider == null ? 43 : ((Object)((Object)$pushProvider)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $disabledReason = this.getDisabledReason();
        result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    public String toString() {
        return "Device(pushProvider=" + this.getPushProvider() + ", id=" + this.getId() + ", createdAt=" + this.getCreatedAt() + ", disabled=" + this.getDisabled() + ", disabledReason=" + this.getDisabledReason() + ", userId=" + this.getUserId() + ")";
    }

    public static class DeviceListResponse
    extends StreamResponseObject {
        @JsonProperty(value="devices")
        @NotNull
        private List<Device> devices;

        @NotNull
        public List<Device> getDevices() {
            return this.devices;
        }

        @JsonProperty(value="devices")
        public void setDevices(@NotNull List<Device> devices) {
            if (devices == null) {
                throw new NullPointerException("devices is marked non-null but is null");
            }
            this.devices = devices;
        }

        @Override
        public String toString() {
            return "Device.DeviceListResponse(devices=" + this.getDevices() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeviceListResponse)) {
                return false;
            }
            DeviceListResponse other = (DeviceListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Device> this$devices = this.getDevices();
            List<Device> other$devices = other.getDevices();
            return !(this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof DeviceListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Device> $devices = this.getDevices();
            result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
            return result;
        }
    }

    public static class DeviceListRequest
    extends StreamRequest<DeviceListResponse> {
        @NotNull
        private String userId;

        @Override
        protected Call<DeviceListResponse> generateCall() {
            return StreamServiceGenerator.createService(DeviceService.class).list(this.userId);
        }

        public DeviceListRequest(@NotNull String userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }
    }

    public static class DeviceDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String id;
        @NotNull
        private String userId;

        @NotNull
        public DeviceDeleteRequest id(@NotNull String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public DeviceDeleteRequest userId(@NotNull String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        protected Call<StreamResponseObject> generateCall() {
            return StreamServiceGenerator.createService(DeviceService.class).delete(this.id, this.userId);
        }

        public DeviceDeleteRequest(@NotNull String id, @NotNull String userId) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.id = id;
            this.userId = userId;
        }
    }

    public static class DeviceCreateRequestData {
        @JsonProperty(value="push_provider")
        @Nullable
        private PushProvider pushProvider;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        DeviceCreateRequestData(@Nullable PushProvider pushProvider, @Nullable String id, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.pushProvider = pushProvider;
            this.id = id;
            this.userId = userId;
            this.user = user;
        }

        public static class DeviceCreateRequest
        extends StreamRequest<StreamResponseObject> {
            private PushProvider pushProvider;
            private String id;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<StreamResponseObject> generateCall() {
                return StreamServiceGenerator.createService(DeviceService.class).create(this.internalBuild());
            }

            DeviceCreateRequest() {
            }

            @JsonProperty(value="push_provider")
            public DeviceCreateRequest pushProvider(@Nullable PushProvider pushProvider) {
                this.pushProvider = pushProvider;
                return this;
            }

            @JsonProperty(value="id")
            public DeviceCreateRequest id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="user_id")
            public DeviceCreateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public DeviceCreateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public DeviceCreateRequestData internalBuild() {
                return new DeviceCreateRequestData(this.pushProvider, this.id, this.userId, this.user);
            }

            public String toString() {
                return "Device.DeviceCreateRequestData.DeviceCreateRequest(pushProvider=" + this.pushProvider + ", id=" + this.id + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class DeviceRequestObject {
        @JsonProperty(value="push_provider")
        @Nullable
        private PushProvider pushProvider;
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="disabled")
        @Nullable
        private Boolean disabled;
        @JsonProperty(value="disabled_reason")
        @Nullable
        private String disabledReason;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        @Nullable
        public static DeviceRequestObject buildFrom(@Nullable Device device) {
            return RequestObjectBuilder.build(DeviceRequestObject.class, device);
        }

        DeviceRequestObject(@Nullable PushProvider pushProvider, @Nullable String id, @Nullable Date createdAt, @Nullable Boolean disabled, @Nullable String disabledReason, @Nullable String userId) {
            this.pushProvider = pushProvider;
            this.id = id;
            this.createdAt = createdAt;
            this.disabled = disabled;
            this.disabledReason = disabledReason;
            this.userId = userId;
        }

        public static DeviceRequestObjectBuilder builder() {
            return new DeviceRequestObjectBuilder();
        }

        @JsonProperty(value="push_provider")
        public void setPushProvider(@Nullable PushProvider pushProvider) {
            this.pushProvider = pushProvider;
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="disabled")
        public void setDisabled(@Nullable Boolean disabled) {
            this.disabled = disabled;
        }

        @JsonProperty(value="disabled_reason")
        public void setDisabledReason(@Nullable String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        public static class DeviceRequestObjectBuilder {
            private PushProvider pushProvider;
            private String id;
            private Date createdAt;
            private Boolean disabled;
            private String disabledReason;
            private String userId;

            DeviceRequestObjectBuilder() {
            }

            @JsonProperty(value="push_provider")
            public DeviceRequestObjectBuilder pushProvider(@Nullable PushProvider pushProvider) {
                this.pushProvider = pushProvider;
                return this;
            }

            @JsonProperty(value="id")
            public DeviceRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="created_at")
            public DeviceRequestObjectBuilder createdAt(@Nullable Date createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @JsonProperty(value="disabled")
            public DeviceRequestObjectBuilder disabled(@Nullable Boolean disabled) {
                this.disabled = disabled;
                return this;
            }

            @JsonProperty(value="disabled_reason")
            public DeviceRequestObjectBuilder disabledReason(@Nullable String disabledReason) {
                this.disabledReason = disabledReason;
                return this;
            }

            @JsonProperty(value="user_id")
            public DeviceRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            public DeviceRequestObject build() {
                return new DeviceRequestObject(this.pushProvider, this.id, this.createdAt, this.disabled, this.disabledReason, this.userId);
            }

            public String toString() {
                return "Device.DeviceRequestObject.DeviceRequestObjectBuilder(pushProvider=" + this.pushProvider + ", id=" + this.id + ", createdAt=" + this.createdAt + ", disabled=" + this.disabled + ", disabledReason=" + this.disabledReason + ", userId=" + this.userId + ")";
            }
        }
    }

    public static enum PushProvider {
        FIREBASE,
        APN,
        UNKNOWN;

    }
}

