/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.PermissionService;
import io.getstream.chat.java.services.framework.StreamServiceGenerator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Permission {
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="resource")
    @NotNull
    private Resource resource;
    @JsonProperty(value="owner")
    @Nullable
    private Boolean owner;
    @JsonProperty(value="same_team")
    @Nullable
    private Boolean sameTeam;
    @JsonProperty(value="custom")
    @NotNull
    private Boolean custom;
    @JsonProperty(value="condition")
    @Nullable
    private Condition condition;

    @NotNull
    public static PermissionCreateRequestData.PermissionCreateRequest create() {
        return new PermissionCreateRequestData.PermissionCreateRequest();
    }

    @NotNull
    public static PermissionGetRequest get(@NotNull String name) {
        return new PermissionGetRequest(name);
    }

    @NotNull
    public static PermissionUpdateRequestData.PermissionUpdateRequest update(@NotNull String name) {
        return new PermissionUpdateRequestData.PermissionUpdateRequest(name);
    }

    @NotNull
    public static PermissionDeleteRequest delete(@NotNull String name) {
        return new PermissionDeleteRequest(name);
    }

    @NotNull
    public static PermissionListRequest list() {
        return new PermissionListRequest();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Resource getResource() {
        return this.resource;
    }

    @Nullable
    public Boolean getOwner() {
        return this.owner;
    }

    @Nullable
    public Boolean getSameTeam() {
        return this.sameTeam;
    }

    @NotNull
    public Boolean getCustom() {
        return this.custom;
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    @JsonProperty(value="name")
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="resource")
    public void setResource(@NotNull Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
    }

    @JsonProperty(value="owner")
    public void setOwner(@Nullable Boolean owner) {
        this.owner = owner;
    }

    @JsonProperty(value="same_team")
    public void setSameTeam(@Nullable Boolean sameTeam) {
        this.sameTeam = sameTeam;
    }

    @JsonProperty(value="custom")
    public void setCustom(@NotNull Boolean custom) {
        if (custom == null) {
            throw new NullPointerException("custom is marked non-null but is null");
        }
        this.custom = custom;
    }

    @JsonProperty(value="condition")
    public void setCondition(@Nullable Condition condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$owner = this.getOwner();
        Boolean other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Boolean this$sameTeam = this.getSameTeam();
        Boolean other$sameTeam = other.getSameTeam();
        if (this$sameTeam == null ? other$sameTeam != null : !((Object)this$sameTeam).equals(other$sameTeam)) {
            return false;
        }
        Boolean this$custom = this.getCustom();
        Boolean other$custom = other.getCustom();
        if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)((Object)this$resource)).equals((Object)other$resource)) {
            return false;
        }
        Condition this$condition = this.getCondition();
        Condition other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Permission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Boolean $sameTeam = this.getSameTeam();
        result = result * 59 + ($sameTeam == null ? 43 : ((Object)$sameTeam).hashCode());
        Boolean $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)((Object)$resource)).hashCode());
        Condition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    public String toString() {
        return "Permission(name=" + this.getName() + ", resource=" + this.getResource() + ", owner=" + this.getOwner() + ", sameTeam=" + this.getSameTeam() + ", custom=" + this.getCustom() + ", condition=" + this.getCondition() + ")";
    }

    public static class PermissionListResponse
    extends StreamResponseObject {
        @JsonProperty(value="permissions")
        @NotNull
        private List<Permission> permissions;

        @NotNull
        public List<Permission> getPermissions() {
            return this.permissions;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(@NotNull List<Permission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = permissions;
        }

        @Override
        public String toString() {
            return "Permission.PermissionListResponse(permissions=" + this.getPermissions() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionListResponse)) {
                return false;
            }
            PermissionListResponse other = (PermissionListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Permission> this$permissions = this.getPermissions();
            List<Permission> other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PermissionListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Permission> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            return result;
        }
    }

    public static class PermissionGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="permission")
        @NotNull
        private Permission permission;

        @NotNull
        public Permission getPermission() {
            return this.permission;
        }

        @JsonProperty(value="permission")
        public void setPermission(@NotNull Permission permission) {
            if (permission == null) {
                throw new NullPointerException("permission is marked non-null but is null");
            }
            this.permission = permission;
        }

        @Override
        public String toString() {
            return "Permission.PermissionGetResponse(permission=" + this.getPermission() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionGetResponse)) {
                return false;
            }
            PermissionGetResponse other = (PermissionGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Permission this$permission = this.getPermission();
            Permission other$permission = other.getPermission();
            return !(this$permission == null ? other$permission != null : !((Object)this$permission).equals(other$permission));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PermissionGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Permission $permission = this.getPermission();
            result = result * 59 + ($permission == null ? 43 : ((Object)$permission).hashCode());
            return result;
        }
    }

    public static class PermissionListRequest
    extends StreamRequest<PermissionListResponse> {
        @Override
        protected Call<PermissionListResponse> generateCall() {
            return StreamServiceGenerator.createService(PermissionService.class).list();
        }
    }

    public static class PermissionDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String name;

        @Override
        protected Call<StreamResponseObject> generateCall() {
            return StreamServiceGenerator.createService(PermissionService.class).delete(this.name);
        }

        public PermissionDeleteRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class PermissionUpdateRequestData {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="resource")
        @Nullable
        private Resource resource;
        @JsonProperty(value="owner")
        @Nullable
        private Boolean owner;
        @JsonProperty(value="same_team")
        @Nullable
        private Boolean sameTeam;
        @JsonProperty(value="condition")
        @Nullable
        private String condition;

        PermissionUpdateRequestData(@Nullable String name, @Nullable Resource resource, @Nullable Boolean owner, @Nullable Boolean sameTeam, @Nullable String condition) {
            this.name = name;
            this.resource = resource;
            this.owner = owner;
            this.sameTeam = sameTeam;
            this.condition = condition;
        }

        public static class PermissionUpdateRequest
        extends StreamRequest<StreamResponseObject> {
            private String name;
            private Resource resource;
            private Boolean owner;
            private Boolean sameTeam;
            private String condition;

            private PermissionUpdateRequest(@NotNull String name) {
                this.name = name;
            }

            private PermissionUpdateRequest name(@NotNull String name) {
                throw new IllegalStateException("Should not use as it is only to hide builder method");
            }

            @Override
            protected Call<StreamResponseObject> generateCall() {
                return StreamServiceGenerator.createService(PermissionService.class).update(this.name, this.internalBuild());
            }

            @JsonProperty(value="resource")
            public PermissionUpdateRequest resource(@Nullable Resource resource) {
                this.resource = resource;
                return this;
            }

            @JsonProperty(value="owner")
            public PermissionUpdateRequest owner(@Nullable Boolean owner) {
                this.owner = owner;
                return this;
            }

            @JsonProperty(value="same_team")
            public PermissionUpdateRequest sameTeam(@Nullable Boolean sameTeam) {
                this.sameTeam = sameTeam;
                return this;
            }

            @JsonProperty(value="condition")
            public PermissionUpdateRequest condition(@Nullable String condition) {
                this.condition = condition;
                return this;
            }

            public PermissionUpdateRequestData internalBuild() {
                return new PermissionUpdateRequestData(this.name, this.resource, this.owner, this.sameTeam, this.condition);
            }

            public String toString() {
                return "Permission.PermissionUpdateRequestData.PermissionUpdateRequest(name=" + this.name + ", resource=" + this.resource + ", owner=" + this.owner + ", sameTeam=" + this.sameTeam + ", condition=" + this.condition + ")";
            }
        }
    }

    public static class PermissionGetRequest
    extends StreamRequest<PermissionGetResponse> {
        @NotNull
        private String name;

        @Override
        protected Call<PermissionGetResponse> generateCall() {
            return StreamServiceGenerator.createService(PermissionService.class).get(this.name);
        }

        public PermissionGetRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class PermissionCreateRequestData {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="resource")
        @Nullable
        private Resource resource;
        @JsonProperty(value="owner")
        @Nullable
        private Boolean owner;
        @JsonProperty(value="same_team")
        @Nullable
        private Boolean sameTeam;
        @JsonProperty(value="condition")
        @Nullable
        private String condition;

        PermissionCreateRequestData(@Nullable String name, @Nullable Resource resource, @Nullable Boolean owner, @Nullable Boolean sameTeam, @Nullable String condition) {
            this.name = name;
            this.resource = resource;
            this.owner = owner;
            this.sameTeam = sameTeam;
            this.condition = condition;
        }

        public static class PermissionCreateRequest
        extends StreamRequest<StreamResponseObject> {
            private String name;
            private Resource resource;
            private Boolean owner;
            private Boolean sameTeam;
            private String condition;

            @Override
            protected Call<StreamResponseObject> generateCall() {
                return StreamServiceGenerator.createService(PermissionService.class).create(this.internalBuild());
            }

            PermissionCreateRequest() {
            }

            @JsonProperty(value="name")
            public PermissionCreateRequest name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="resource")
            public PermissionCreateRequest resource(@Nullable Resource resource) {
                this.resource = resource;
                return this;
            }

            @JsonProperty(value="owner")
            public PermissionCreateRequest owner(@Nullable Boolean owner) {
                this.owner = owner;
                return this;
            }

            @JsonProperty(value="same_team")
            public PermissionCreateRequest sameTeam(@Nullable Boolean sameTeam) {
                this.sameTeam = sameTeam;
                return this;
            }

            @JsonProperty(value="condition")
            public PermissionCreateRequest condition(@Nullable String condition) {
                this.condition = condition;
                return this;
            }

            public PermissionCreateRequestData internalBuild() {
                return new PermissionCreateRequestData(this.name, this.resource, this.owner, this.sameTeam, this.condition);
            }

            public String toString() {
                return "Permission.PermissionCreateRequestData.PermissionCreateRequest(name=" + this.name + ", resource=" + this.resource + ", owner=" + this.owner + ", sameTeam=" + this.sameTeam + ", condition=" + this.condition + ")";
            }
        }
    }

    public static enum Resource {
        CREATE_CHANNEL,
        CREATE_DISTINCT_CHANNEL_FOR_OTHERS,
        READ_CHANNEL,
        UPDATE_CHANNEL_MEMBERS,
        REMOVE_OWN_CHANNEL_MEMBERSHIP,
        UPDATE_CHANNEL,
        USE_FROZEN_CHANNEL,
        UPDATE_USER_ROLE,
        DELETE_CHANNEL,
        CREATE_MESSAGE,
        UPDATE_MESSAGE,
        PIN_MESSAGE,
        DELETE_MESSAGE,
        RUN_MESSAGE_ACTION,
        MUTE_USER,
        BAN_USER,
        UPLOAD_ATTACHMENT,
        DELETE_ATTACHMENT,
        ADD_LINKS,
        CREATE_REACTION,
        DELETE_REACTION,
        SEND_CUSTOM_EVENT,
        SKIP_MESSAGE_MODERATION,
        USE_COMMANDS,
        EDIT_USER,
        READ_MESSAGE_FLAGS,
        ALL,
        UNKNOWN;

    }

    public static class Condition {
        @NotNull
        private String expression;

        @NotNull
        public String getExpression() {
            return this.expression;
        }

        public void setExpression(@NotNull String expression) {
            if (expression == null) {
                throw new NullPointerException("expression is marked non-null but is null");
            }
            this.expression = expression;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Condition)) {
                return false;
            }
            Condition other = (Condition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Condition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        public String toString() {
            return "Permission.Condition(expression=" + this.getExpression() + ")";
        }
    }
}

