/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.RoleService;
import io.getstream.chat.java.services.framework.StreamServiceGenerator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Role {
    @NotNull
    public static RoleCreateRequestData.RoleCreateRequest create() {
        return new RoleCreateRequestData.RoleCreateRequest();
    }

    @NotNull
    public static RoleDeleteRequest delete(@NotNull String name) {
        return new RoleDeleteRequest(name);
    }

    @NotNull
    public static RoleListRequest list() {
        return new RoleListRequest();
    }

    public static class RoleListResponse
    extends StreamResponseObject {
        @JsonProperty(value="roles")
        @NotNull
        private List<String> roles;

        @NotNull
        public List<String> getRoles() {
            return this.roles;
        }

        @JsonProperty(value="roles")
        public void setRoles(@NotNull List<String> roles) {
            if (roles == null) {
                throw new NullPointerException("roles is marked non-null but is null");
            }
            this.roles = roles;
        }

        @Override
        public String toString() {
            return "Role.RoleListResponse(roles=" + this.getRoles() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleListResponse)) {
                return false;
            }
            RoleListResponse other = (RoleListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$roles = this.getRoles();
            List<String> other$roles = other.getRoles();
            return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof RoleListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $roles = this.getRoles();
            result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
            return result;
        }
    }

    public static class RoleListRequest
    extends StreamRequest<RoleListResponse> {
        @Override
        protected Call<RoleListResponse> generateCall() {
            return StreamServiceGenerator.createService(RoleService.class).list();
        }
    }

    public static class RoleDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String name;

        @Override
        protected Call<StreamResponseObject> generateCall() {
            return StreamServiceGenerator.createService(RoleService.class).delete(this.name);
        }

        public RoleDeleteRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class RoleCreateRequestData {
        @JsonProperty(value="name")
        @Nullable
        private String name;

        RoleCreateRequestData(@Nullable String name) {
            this.name = name;
        }

        public static class RoleCreateRequest
        extends StreamRequest<StreamResponseObject> {
            private String name;

            @Override
            protected Call<StreamResponseObject> generateCall() {
                return StreamServiceGenerator.createService(RoleService.class).create(this.internalBuild());
            }

            RoleCreateRequest() {
            }

            @JsonProperty(value="name")
            public RoleCreateRequest name(@Nullable String name) {
                this.name = name;
                return this;
            }

            public RoleCreateRequestData internalBuild() {
                return new RoleCreateRequestData(this.name);
            }

            public String toString() {
                return "Role.RoleCreateRequestData.RoleCreateRequest(name=" + this.name + ")";
            }
        }
    }
}

