/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import io.getstream.chat.java.services.framework.HttpLoggingInterceptor;
import io.getstream.chat.java.services.framework.QueryConverterFactory;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class StreamServiceGenerator {
    private static final Logger log = Logger.getLogger(StreamServiceGenerator.class.getName());
    private static Retrofit retrofit;
    public static HttpLoggingInterceptor.Level logLevel;
    private static boolean failOnUnknownProperties;
    private static String apiKey;
    private static String apiSecret;

    private static void initKeys() {
        apiKey = System.getenv("STREAM_KEY") != null ? System.getenv("STREAM_KEY") : System.getProperty("STREAM_KEY");
        apiSecret = System.getenv("STREAM_SECRET") != null ? System.getenv("STREAM_SECRET") : System.getProperty("STREAM_SECRET");
    }

    @NotNull
    public static <S> S createService(@NotNull Class<S> serviceClass) {
        if (retrofit == null) {
            StreamServiceGenerator.initKeys();
            if (apiKey == null) {
                throw new IllegalStateException("Missing Stream API key. Please set STREAM_KEY environment variable or System property");
            }
            if (apiSecret == null) {
                throw new IllegalStateException("Missing Stream API secret. Please set STREAM_SECRET environment variable or System property");
            }
            int streamChatTimeout = System.getenv("STREAM_CHAT_URL") != null ? Integer.parseInt(System.getenv("STREAM_CHAT_TIMEOUT")) : Integer.getInteger("STREAM_CHAT_TIMEOUT", 10000);
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder().connectTimeout((long)streamChatTimeout, TimeUnit.MILLISECONDS);
            httpClient.interceptors().clear();
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor().setLevel(logLevel);
            httpClient.addInterceptor((Interceptor)loggingInterceptor);
            httpClient.addInterceptor(chain -> {
                Request original = chain.request();
                HttpUrl url = original.url().newBuilder().addQueryParameter("api_key", apiKey).build();
                Request request = original.newBuilder().url(url).header("Content-Type", "application/json").header("X-Stream-Client", "stream-java-client-" + StreamServiceGenerator.sdkVersion()).header("Stream-Auth-Type", "jwt").header("Authorization", StreamServiceGenerator.jwtToken()).build();
                return chain.proceed(request);
            });
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
            mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getTimeZone("UTC")));
            mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
            String baseUrl = System.getenv("STREAM_CHAT_URL") != null ? System.getenv("STREAM_CHAT_URL") : System.getProperty("STREAM_CHAT_URL", "https://chat-proxy-us-east.stream-io-api.com");
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)new QueryConverterFactory()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper));
            builder.client(httpClient.build());
            retrofit = builder.build();
        }
        return (S)retrofit.create(serviceClass);
    }

    @NotNull
    private static String sdkVersion() {
        Properties properties = new Properties();
        try {
            properties.load(StreamServiceGenerator.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            log.severe("Missing version.properties, should not happen");
        }
        return properties.getProperty("version");
    }

    @NotNull
    private static String jwtToken() {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(apiSecret.getBytes("UTF-8"), SignatureAlgorithm.HS256.getJcaName());
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.add(13, -5);
            return Jwts.builder().setIssuedAt(new Date()).setIssuer("Stream Chat Java SDK").setSubject("Stream Chat Java SDK").claim("server", (Object)true).claim("scope", (Object)"admins").setIssuedAt(calendar.getTime()).signWith((Key)signingKey, SignatureAlgorithm.HS256).compact();
        }
        catch (UnsupportedEncodingException e) {
            log.severe("Should not happen: UTF-8 is not supported");
            return "";
        }
    }

    static {
        logLevel = HttpLoggingInterceptor.Level.NONE;
        failOnUnknownProperties = false;
    }
}

