/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import io.getstream.chat.java.services.framework.Client;
import io.getstream.chat.java.services.framework.HttpLoggingInterceptor;
import io.getstream.chat.java.services.framework.QueryConverterFactory;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DefaultClient
implements Client {
    public static final String API_KEY_PROP_NAME = "io.getstream.chat.apiKey";
    public static final String API_SECRET_PROP_NAME = "io.getstream.chat.apiSecret";
    public static final String API_TIMEOUT_PROP_NAME = "io.getstream.chat.timeout";
    public static final String API_URL_PROP_NAME = "io.getstream.chat.url";
    private static final String API_DEFAULT_URL = "https://chat.stream-io-api.com";
    private static volatile DefaultClient defaultInstance;
    @NotNull
    private final Retrofit retrofit;
    @NotNull
    private final String apiSecret;
    @NotNull
    private final String apiKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultClient getInstance() {
        if (defaultInstance != null) return defaultInstance;
        Class<DefaultClient> clazz = DefaultClient.class;
        synchronized (DefaultClient.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new DefaultClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static void setInstance(@NotNull DefaultClient instance) {
        defaultInstance = instance;
    }

    public DefaultClient() {
        this(System.getProperties());
    }

    public DefaultClient(Properties properties) {
        properties = DefaultClient.extendProperties(properties);
        Object apiKey = properties.get(API_KEY_PROP_NAME);
        Object apiSecret = properties.get(API_SECRET_PROP_NAME);
        if (apiSecret == null) {
            throw new IllegalStateException("Missing Stream API secret. Please set STREAM_SECRET environment variable or System property");
        }
        if (apiKey == null) {
            throw new IllegalStateException("Missing Stream API key. Please set STREAM_KEY environment variable or System property");
        }
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 59L, TimeUnit.SECONDS)).callTimeout(DefaultClient.getStreamChatTimeout(properties), TimeUnit.MILLISECONDS);
        httpClient.interceptors().clear();
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor().setLevel(DefaultClient.getLogLevel(properties));
        httpClient.addInterceptor((Interceptor)loggingInterceptor);
        httpClient.addInterceptor(chain -> {
            Request original = chain.request();
            HttpUrl url = original.url().newBuilder().addQueryParameter("api_key", apiKey.toString()).build();
            Request request = original.newBuilder().url(url).header("Content-Type", "application/json").header("X-Stream-Client", "stream-java-client-" + DefaultClient.getSdkVersion()).header("Stream-Auth-Type", "jwt").header("Authorization", DefaultClient.jwtToken(apiSecret.toString())).build();
            return chain.proceed(request);
        });
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DefaultClient.hasFailOnUnknownProperties(properties));
        mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getTimeZone("UTC")));
        mapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        Retrofit.Builder builder = new Retrofit.Builder().baseUrl(DefaultClient.getStreamChatBaseUrl(properties)).addConverterFactory((Converter.Factory)new QueryConverterFactory()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper));
        builder.client(httpClient.build());
        this.retrofit = builder.build();
        this.apiSecret = apiSecret.toString();
        this.apiKey = apiKey.toString();
    }

    @Override
    @NotNull
    public <TService> TService create(Class<TService> svcClass) {
        return (TService)this.retrofit.create(svcClass);
    }

    @Override
    @NotNull
    public String getApiSecret() {
        return this.apiSecret;
    }

    @Override
    @NotNull
    public String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    private static String jwtToken(String apiSecret) {
        SecretKeySpec signingKey = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), SignatureAlgorithm.HS256.getJcaName());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(13, -5);
        return Jwts.builder().setIssuedAt(new Date()).setIssuer("Stream Chat Java SDK").setSubject("Stream Chat Java SDK").claim("server", (Object)true).claim("scope", (Object)"admins").setIssuedAt(calendar.getTime()).signWith((Key)signingKey, SignatureAlgorithm.HS256).compact();
    }

    @NotNull
    private static Properties extendProperties(Properties properties) {
        String envApiUrl;
        String envTimeout;
        String envApiKey;
        Properties canformedProperties = new Properties();
        Map<String, String> env = System.getenv();
        String envApiSecret = env.getOrDefault("STREAM_SECRET", System.getProperty("STREAM_SECRET"));
        if (envApiSecret != null) {
            canformedProperties.put(API_SECRET_PROP_NAME, envApiSecret);
        }
        if ((envApiKey = env.getOrDefault("STREAM_KEY", System.getProperty("STREAM_KEY"))) != null) {
            canformedProperties.put(API_KEY_PROP_NAME, envApiKey);
        }
        if ((envTimeout = env.getOrDefault("STREAM_CHAT_TIMEOUT", System.getProperty("STREAM_CHAT_TIMEOUT"))) != null) {
            canformedProperties.put(API_TIMEOUT_PROP_NAME, envTimeout);
        }
        if ((envApiUrl = env.getOrDefault("STREAM_CHAT_URL", System.getProperty("STREAM_CHAT_URL"))) != null) {
            canformedProperties.put(API_URL_PROP_NAME, envApiUrl);
        }
        canformedProperties.putAll((Map<?, ?>)System.getProperties());
        canformedProperties.putAll((Map<?, ?>)properties);
        return canformedProperties;
    }

    private static long getStreamChatTimeout(@NotNull Properties properties) {
        Object timeout = properties.getOrDefault((Object)API_TIMEOUT_PROP_NAME, (Object)10000);
        return Long.parseLong(timeout.toString());
    }

    private static String getStreamChatBaseUrl(@NotNull Properties properties) {
        Object url = properties.getOrDefault((Object)API_URL_PROP_NAME, API_DEFAULT_URL);
        return url.toString();
    }

    @NotNull
    private static String getSdkVersion() {
        String string;
        block8: {
            ClassLoader clsLoader = DefaultClient.class.getClassLoader();
            InputStream inputStream = clsLoader.getResourceAsStream("version.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @NotNull
    private static HttpLoggingInterceptor.Level getLogLevel(@NotNull Properties properties) {
        String propName = "io.getstream.chat.debug.logLevel";
        String logLevel = properties.getOrDefault((Object)"io.getstream.chat.debug.logLevel", "NONE").toString();
        return HttpLoggingInterceptor.Level.valueOf(logLevel);
    }

    private static boolean hasFailOnUnknownProperties(@NotNull Properties properties) {
        String propName = "io.getstream.chat.debug.failOnUnknownProperties";
        Object hasEnabled = properties.getOrDefault((Object)"io.getstream.chat.debug.failOnUnknownProperties", "false");
        return Boolean.parseBoolean(hasEnabled.toString());
    }
}

