/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models.framework;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.FileHandler;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.MessageService;
import io.getstream.chat.java.services.framework.StreamServiceGenerator;
import io.getstream.chat.java.services.framework.StreamServiceHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class DefaultFileHandler
implements FileHandler {
    private static final Logger log = Logger.getLogger(DefaultFileHandler.class.getName());

    @Override
    public Message.MessageUploadFileResponse uploadFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType) throws StreamException {
        return new StreamServiceHandler().handle(this.generateUploadFileCall(channelType, channelId, userId, file, contentType));
    }

    @Override
    public Message.MessageUploadImageResponse uploadImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType, @Nullable List<Message.ImageSizeRequestObject> uploadSizes) throws StreamException {
        return new StreamServiceHandler().handle(this.generateUploadImageCall(channelType, channelId, userId, file, contentType, uploadSizes));
    }

    @Override
    public StreamResponseObject deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String url) throws StreamException {
        return new StreamServiceHandler().handle(this.generateDeleteFileCall(channelType, channelId, url));
    }

    @Override
    public StreamResponseObject deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String url) throws StreamException {
        return new StreamServiceHandler().handle(this.generateDeleteImageCall(channelType, channelId, url));
    }

    @Override
    public void uploadFileAsync(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType, @Nullable Consumer<Message.MessageUploadFileResponse> onSuccess, @Nullable Consumer<StreamException> onError) {
        block2: {
            try {
                new StreamServiceHandler().handleAsync(this.generateUploadFileCall(channelType, channelId, userId, file, contentType), onSuccess, onError);
            }
            catch (StreamException e) {
                if (onError == null) break block2;
                onError.accept(e);
            }
        }
    }

    @Override
    public void uploadImageAsync(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType, @Nullable List<Message.ImageSizeRequestObject> uploadSizes, @Nullable Consumer<Message.MessageUploadImageResponse> onSuccess, @Nullable Consumer<StreamException> onError) {
        block2: {
            try {
                new StreamServiceHandler().handleAsync(this.generateUploadImageCall(channelType, channelId, userId, file, contentType, uploadSizes), onSuccess, onError);
            }
            catch (StreamException e) {
                if (onError == null) break block2;
                onError.accept(e);
            }
        }
    }

    @Override
    public void deleteFileAsync(@NotNull String channelType, @NotNull String channelId, @NotNull String url, @Nullable Consumer<StreamResponseObject> onSuccess, @Nullable Consumer<StreamException> onError) {
        new StreamServiceHandler().handleAsync(this.generateDeleteFileCall(channelType, channelId, url), onSuccess, onError);
    }

    @Override
    public void deleteImageAsync(@NotNull String channelType, @NotNull String channelId, @NotNull String url, @Nullable Consumer<StreamResponseObject> onSuccess, @Nullable Consumer<StreamException> onError) {
        new StreamServiceHandler().handleAsync(this.generateDeleteImageCall(channelType, channelId, url), onSuccess, onError);
    }

    private Call<Message.MessageUploadFileResponse> generateUploadFileCall(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType) throws StreamException {
        try {
            if (file == null) {
                throw StreamException.build("You should specify the file");
            }
            String resolvedContentType = contentType != null ? contentType : "application/octet-stream";
            RequestBody fileRequestBody = RequestBody.create((MediaType)MediaType.parse((String)resolvedContentType), (File)file);
            MultipartBody.Part multipartFile = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileRequestBody);
            User.UserRequestObject user = User.UserRequestObject.builder().id(userId).build();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectMapper().writeValue((OutputStream)baos, (Object)user);
            RequestBody userRequestBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)baos.toString("UTF-8"));
            return StreamServiceGenerator.createService(MessageService.class).uploadFile(channelType, channelId, userRequestBody, multipartFile);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Seems there is a problem with the conversion of user request object to json", e);
            return null;
        }
    }

    private Call<Message.MessageUploadImageResponse> generateUploadImageCall(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable File file, @Nullable String contentType, @Nullable List<Message.ImageSizeRequestObject> uploadSizes) throws StreamException {
        try {
            if (file == null) {
                throw StreamException.build("You should specify the file");
            }
            RequestBody fileRequestBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)file);
            MultipartBody.Part multipartFile = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileRequestBody);
            User.UserRequestObject user = User.UserRequestObject.builder().id(userId).build();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectMapper().writeValue((OutputStream)baos, (Object)user);
            RequestBody userRequestBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)baos.toString("UTF-8"));
            baos = new ByteArrayOutputStream();
            new ObjectMapper().writeValue((OutputStream)baos, uploadSizes);
            RequestBody uploadSizesRequestBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)baos.toString("UTF-8"));
            return StreamServiceGenerator.createService(MessageService.class).uploadImage(channelType, channelId, userRequestBody, multipartFile, uploadSizesRequestBody);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Seems there is a problem with the conversion of user request object or image size request object to json", e);
            return null;
        }
    }

    private Call<StreamResponseObject> generateDeleteFileCall(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return StreamServiceGenerator.createService(MessageService.class).deleteFile(channelType, channelId, url);
    }

    private Call<StreamResponseObject> generateDeleteImageCall(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return StreamServiceGenerator.createService(MessageService.class).deleteImage(channelType, channelId, url);
    }
}

