/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.logging.kotlin;

import io.getstream.logging.Priority;
import io.getstream.logging.StreamLogger;
import io.getstream.logging.helper.StringifyKt;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/getstream/logging/kotlin/KotlinStreamLogger;", "Lio/getstream/logging/StreamLogger;", "dateFormat", "Ljava/text/DateFormat;", "(Ljava/text/DateFormat;)V", "log", "", "priority", "Lio/getstream/logging/Priority;", "tag", "", "message", "throwable", "", "now", "", "stream-logger"})
public final class KotlinStreamLogger
implements StreamLogger {
    @NotNull
    private final DateFormat dateFormat;

    public KotlinStreamLogger(@NotNull DateFormat dateFormat) {
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        this.dateFormat = dateFormat;
    }

    public /* synthetic */ KotlinStreamLogger(DateFormat dateFormat, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss''SSS", Locale.ENGLISH);
        }
        this(dateFormat);
    }

    @Override
    public void log(@NotNull Priority priority, @NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String now = this.dateFormat.format(this.now());
        Thread $this$log_u24lambda_u2d0 = Thread.currentThread();
        boolean bl = false;
        String thread = $this$log_u24lambda_u2d0.getName() + ':' + $this$log_u24lambda_u2d0.getId();
        String composed = now + " (" + thread + ") [" + StringifyKt.stringify(priority) + '/' + tag + "]: " + message;
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            string = composed;
        } else {
            Throwable it = throwable2;
            boolean bl2 = false;
            String string2 = composed + '\n' + StringifyKt.stringify(it);
            string = string2 == null ? composed : string2;
        }
        String finalMessage = string;
        switch (WhenMappings.$EnumSwitchMapping$0[priority.ordinal()]) {
            case 1: 
            case 2: {
                System.err.println(finalMessage);
                break;
            }
            default: {
                System.out.println((Object)finalMessage);
            }
        }
    }

    private final long now() {
        return System.currentTimeMillis();
    }

    public KotlinStreamLogger() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Priority.values().length];
            nArray[Priority.ERROR.ordinal()] = 1;
            nArray[Priority.ASSERT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

