/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.bean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Consumer;

public final class ResponseResult
implements Serializable {
    private String code;
    private String message;
    private Object data;
    private Object[] args;

    public ResponseResult then(Consumer<Object> consumer, Object param) {
        consumer.accept(param);
        return this;
    }

    public static ResponseResult success() {
        return ResponseResult.builder().code("0").message("success").build();
    }

    public static ResponseResult success(String code, Object ... args) {
        return ResponseResult.builder().code(code).args(args).build();
    }

    public static ResponseResult success(Object data) {
        ResponseResult success = ResponseResult.success();
        success.setData(data);
        return success;
    }

    public static ResponseResult success(String code, Object data, Object ... args) {
        return ResponseResult.builder().code(code).data(data).args(args).build();
    }

    public static ResponseResult fail() {
        return ResponseResult.builder().code("-1").build();
    }

    public static ResponseResult fail(String code, Object ... args) {
        return ResponseResult.builder().code(code).args(args).build();
    }

    public static ResponseResult fail(String code, Object data, Object ... args) {
        return ResponseResult.builder().code(code).data(data).args(args).build();
    }

    ResponseResult(String code, String message, Object data, Object[] args) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.args = args;
    }

    public static ResponseResultBuilder builder() {
        return new ResponseResultBuilder();
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseResult)) {
            return false;
        }
        ResponseResult other = (ResponseResult)o;
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String toString() {
        return "ResponseResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }

    public static class ResponseResultBuilder {
        private String code;
        private String message;
        private Object data;
        private Object[] args;

        ResponseResultBuilder() {
        }

        public ResponseResultBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ResponseResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ResponseResultBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public ResponseResultBuilder args(Object[] args) {
            this.args = args;
            return this;
        }

        public ResponseResult build() {
            return new ResponseResult(this.code, this.message, this.data, this.args);
        }

        public String toString() {
            return "ResponseResult.ResponseResultBuilder(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ", args=" + Arrays.deepToString(this.args) + ")";
        }
    }
}

