/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.bean;

import io.gitee.thinkbungee.crud.mongo.reflection.SerializableFunction;
import io.gitee.thinkbungee.crud.mongo.utils.FunctionResolveUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public class SortBuilder {
    protected List<Sort.Order> orderList = new ArrayList<Sort.Order>();

    public SortBuilder() {
    }

    public SortBuilder(List<Sort.Order> orderList) {
        this.orderList.addAll(orderList);
    }

    public <T, R> SortBuilder(SerializableFunction<T, R> column, Sort.Direction direction) {
        Sort.Order order = new Sort.Order(direction, FunctionResolveUtils.resolve(column));
        this.orderList.add(order);
    }

    public SortBuilder(String column, Sort.Direction direction) {
        Sort.Order order = new Sort.Order(direction, column);
        this.orderList.add(order);
    }

    public Sort build() {
        return Sort.by(this.orderList);
    }

    public <T, R> SortBuilder add(SerializableFunction<T, R> column, Sort.Direction direction) {
        this.orderList.add(new Sort.Order(direction, FunctionResolveUtils.resolve(column)));
        return this;
    }

    public SortBuilder add(String column, Sort.Direction direction) {
        this.orderList.add(new Sort.Order(direction, column));
        return this;
    }

    private static SortBuilder asc(String column) {
        return new SortBuilder().add(column, Sort.Direction.ASC);
    }

    private static SortBuilder desc(String column) {
        return new SortBuilder().add(column, Sort.Direction.DESC);
    }

    public static List<SortBuilder> ascs(String[] orderColumns) {
        return Arrays.stream(orderColumns).map(SortBuilder::asc).collect(Collectors.toList());
    }

    public static List<SortBuilder> descs(String[] orderColumns) {
        return Arrays.stream(orderColumns).map(SortBuilder::desc).collect(Collectors.toList());
    }
}

