/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.controller;

import io.gitee.thinkbungee.bean.ResponseResult;
import io.gitee.thinkbungee.crud.BaseDTO;
import io.gitee.thinkbungee.crud.BaseEntity;
import io.gitee.thinkbungee.crud.PageParam;
import io.gitee.thinkbungee.crud.mongo.bean.MongoPage;
import io.gitee.thinkbungee.crud.mongo.service.SatelliteMongoBaseService;
import io.gitee.thinkbungee.utils.CollectionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class SatelliteMongoBaseController<P extends PageParam, T extends BaseEntity, D extends BaseDTO> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract SatelliteMongoBaseService<P, T> getService();

    public abstract T getEntity();

    public abstract D getDTO();

    @GetMapping(value={"/pageList"})
    public ResponseResult pageList(P param) {
        MongoPage<T> mongoPage = this.getService().page(param);
        List<T> records = mongoPage.getRecords();
        List<?> result = CollectionUtils.copyList(records, this.getDTO().getClass());
        this.processAfterResult(result);
        MongoPage page = new MongoPage();
        page.setCurrent(mongoPage.getCurrent());
        page.setRecords(result);
        page.setTotal(mongoPage.getTotal());
        page.setSize(mongoPage.getSize());
        return ResponseResult.success(page);
    }

    @GetMapping(value={"/{id}"})
    public ResponseResult detail(@PathVariable(value="id") String id) {
        T t = this.getService().selectById(id);
        D d = this.getDTO();
        BeanUtils.copyProperties(t, d);
        this.processAfterResult(d);
        return ResponseResult.success(d);
    }

    @PostMapping
    public ResponseResult insert(@Validated @RequestBody D d) {
        T t = this.getEntity();
        BeanUtils.copyProperties(d, t);
        this.getService().insert(t);
        return ResponseResult.success();
    }

    @PutMapping
    public ResponseResult update(@Validated @RequestBody D d) {
        T t = this.getEntity();
        BeanUtils.copyProperties(d, t);
        this.getService().update(t);
        return ResponseResult.success();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseResult deleteById(@PathVariable(value="id") String id) {
        this.getService().deleteById(id);
        return ResponseResult.success();
    }

    @PostMapping(value={"/delete/batch"})
    public ResponseResult deleteByBatchIds(@RequestBody List<String> ids) {
        this.getService().deleteByIds(ids);
        return ResponseResult.success(true);
    }

    public D processAfterResult(D d) {
        return d;
    }

    public List<D> processAfterResult(List<D> result) {
        return result;
    }
}

