/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.criteria;

import cn.hutool.core.collection.CollUtil;
import io.gitee.thinkbungee.crud.mongo.criteria.CriteriaOrWrapper;
import io.gitee.thinkbungee.crud.mongo.reflection.SerializableFunction;
import io.gitee.thinkbungee.crud.mongo.utils.FunctionResolveUtils;
import io.gitee.thinkbungee.utils.SatelliteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.core.query.Criteria;

public class CriteriaWrapper {
    boolean andLink = true;
    protected Criteria criteria;
    List<Criteria> list = new ArrayList<Criteria>();

    public Criteria build() {
        this.criteria = new Criteria();
        if (CollUtil.isNotEmpty(this.list)) {
            if (this.andLink) {
                this.criteria.andOperator(this.listToArray(this.list));
            } else {
                this.criteria.orOperator(this.listToArray(this.list));
            }
        }
        return this.criteria;
    }

    private Criteria[] listToArray(List<Criteria> list) {
        return list.toArray(new Criteria[list.size()]);
    }

    public <T, R> CriteriaWrapper eq(SerializableFunction<T, R> column, Object value) {
        return this.eq(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper eq(String column, Object value) {
        this.list.add(Criteria.where((String)column).is(value));
        return this;
    }

    public <T, R> CriteriaWrapper ne(SerializableFunction<T, R> column, Object value) {
        return this.ne(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper ne(String column, Object value) {
        this.list.add(Criteria.where((String)column).ne(value));
        return this;
    }

    public <T, R> CriteriaWrapper lt(SerializableFunction<T, R> column, Object value) {
        return this.lt(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper lt(String column, Object value) {
        this.list.add(Criteria.where((String)column).lt(value));
        return this;
    }

    public <T, R> CriteriaWrapper lte(SerializableFunction<T, R> column, Object value) {
        return this.lte(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper lte(String column, Object value) {
        this.list.add(Criteria.where((String)column).lte(value));
        return this;
    }

    public <T, R> CriteriaWrapper gt(SerializableFunction<T, R> column, Object value) {
        return this.gt(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper gt(String column, Object value) {
        this.list.add(Criteria.where((String)column).gt(value));
        return this;
    }

    public <T, R> CriteriaWrapper gte(SerializableFunction<T, R> column, Object value) {
        return this.gte(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper gte(String column, Object value) {
        this.list.add(Criteria.where((String)column).gte(value));
        return this;
    }

    public <T, R> CriteriaWrapper contain(SerializableFunction<T, R> column, Object value) {
        return this.contain(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper contain(String column, Object value) {
        this.list.add(Criteria.where((String)column).all(new Object[]{value}));
        return this;
    }

    public <T, R> CriteriaWrapper containOr(SerializableFunction<T, R> column, Collection<?> value) {
        return this.containOr(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper containOr(String column, Collection<?> value) {
        CriteriaOrWrapper criteriaOrWrapper = new CriteriaOrWrapper();
        value.forEach(v -> criteriaOrWrapper.contain(column, v));
        this.list.add(criteriaOrWrapper.build());
        return this;
    }

    public <T, R> CriteriaWrapper containOr(SerializableFunction<T, R> column, Object[] values) {
        return this.containOr(column, Arrays.asList(values));
    }

    public CriteriaWrapper containOr(String column, Object[] values) {
        return this.containOr(column, Arrays.asList(values));
    }

    public <T, R> CriteriaWrapper containAnd(SerializableFunction<T, R> column, Collection<?> value) {
        return this.containAnd(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper containAnd(String column, Collection<?> value) {
        this.list.add(Criteria.where((String)column).all(value));
        return this;
    }

    public <T, R> CriteriaWrapper containAnd(SerializableFunction<T, R> column, Object[] values) {
        return this.containAnd(column, Arrays.asList(values));
    }

    public CriteriaWrapper containAnd(String column, Object[] values) {
        return this.containAnd(column, Arrays.asList(values));
    }

    public <T, R> CriteriaWrapper like(SerializableFunction<T, R> column, String value) {
        return this.like(FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper like(String column, String value) {
        Pattern pattern = Pattern.compile("^.*" + SatelliteUtils.repalceSpecialWord(value) + ".*$", 2);
        this.list.add(Criteria.where((String)column).regex(pattern));
        return this;
    }

    public <T, R> CriteriaWrapper in(SerializableFunction<T, R> column, Collection<?> values) {
        return this.in(FunctionResolveUtils.resolve(column), values);
    }

    public CriteriaWrapper in(String column, Collection<?> values) {
        this.list.add(Criteria.where((String)column).in(values));
        return this;
    }

    public <T, R> CriteriaWrapper in(SerializableFunction<T, R> column, Object[] values) {
        return this.in(column, Arrays.asList(values));
    }

    public CriteriaWrapper in(String column, Object[] values) {
        return this.in(column, Arrays.asList(values));
    }

    public <T, R> CriteriaWrapper nin(SerializableFunction<T, R> column, Collection<?> values) {
        return this.nin(FunctionResolveUtils.resolve(column), values);
    }

    public CriteriaWrapper nin(String column, Collection<?> values) {
        this.list.add(Criteria.where((String)column).nin(values));
        return this;
    }

    public <T, R> CriteriaWrapper nin(SerializableFunction<T, R> column, Object[] values) {
        return this.nin(column, Arrays.asList(values));
    }

    public CriteriaWrapper nin(String column, Object[] values) {
        return this.nin(column, Arrays.asList(values));
    }

    public <T, R> CriteriaWrapper isNull(SerializableFunction<T, R> column) {
        return this.isNull(FunctionResolveUtils.resolve(column));
    }

    public CriteriaWrapper isNull(String column) {
        this.list.add(Criteria.where((String)column).is(null));
        return this;
    }

    public <T, R> CriteriaWrapper isNotNull(SerializableFunction<T, R> column) {
        return this.isNotNull(FunctionResolveUtils.resolve(column));
    }

    public CriteriaWrapper isNotNull(String column) {
        this.list.add(Criteria.where((String)column).ne(null));
        return this;
    }

    public <T, R> CriteriaWrapper findArray(String arr, SerializableFunction<T, R> column, Object value) {
        return this.findArray(arr, FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper findArray(String arr, String column, Object value) {
        this.list.add(Criteria.where((String)arr).elemMatch(Criteria.where((String)column).is(value)));
        return this;
    }

    public <T, R> CriteriaWrapper findArrayLike(String arr, SerializableFunction<T, R> column, String value) {
        return this.findArrayLike(arr, FunctionResolveUtils.resolve(column), value);
    }

    public CriteriaWrapper findArrayLike(String arr, String column, String value) {
        Pattern pattern = Pattern.compile("^.*" + SatelliteUtils.repalceSpecialWord(value) + ".*$", 2);
        this.list.add(Criteria.where((String)arr).elemMatch(Criteria.where((String)column).regex(pattern)));
        return this;
    }
}

