/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import io.gitee.thinkbungee.contant.SatelliteConstant;
import io.gitee.thinkbungee.crud.mongo.annotation.CreateTime;
import io.gitee.thinkbungee.crud.mongo.annotation.InitValue;
import io.gitee.thinkbungee.crud.mongo.annotation.UpdateTime;
import io.gitee.thinkbungee.crud.mongo.bean.MongoPage;
import io.gitee.thinkbungee.crud.mongo.bean.SortBuilder;
import io.gitee.thinkbungee.crud.mongo.bean.UpdateBuilder;
import io.gitee.thinkbungee.crud.mongo.criteria.CriteriaAndWrapper;
import io.gitee.thinkbungee.crud.mongo.criteria.CriteriaWrapper;
import io.gitee.thinkbungee.crud.mongo.entity.SlowQuery;
import io.gitee.thinkbungee.crud.mongo.reflection.SerializableFunction;
import io.gitee.thinkbungee.crud.mongo.utils.FunctionResolveUtils;
import io.gitee.thinkbungee.utils.SystemUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class MongoCRUDHelper {
    private static final Logger log = LoggerFactory.getLogger(MongoCRUDHelper.class);
    @Autowired
    protected MongoTemplate mongoTemplate;
    protected QueryMapper queryMapper;
    protected UpdateMapper updateMapper;
    @Autowired
    private MongoConverter mongoConverter;
    @Value(value="${spring.data.mongodb.showSql:false}")
    protected Boolean showSql;
    @Value(value="${spring.data.mongodb.slowQuery:false}")
    protected Boolean slowQuery;
    @Value(value="${spring.data.mongodb.slowTime:1000}")
    protected Long slowTime;

    @PostConstruct
    public void init() {
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
    }

    public String insertOrUpdate(Object object) {
        Object objectDB;
        long time = System.currentTimeMillis();
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object v0 = objectDB = StrUtil.isNotEmpty((CharSequence)id) ? this.findById(id, object.getClass()) : null;
        if (objectDB == null) {
            this.setCreateTime(object, time);
            this.setUpdateTime(object, time);
            this.setInitValue(object);
            ReflectUtil.setFieldValue((Object)object, (String)"id", null);
            this.mongoTemplate.save(object);
            id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
            this.logSave(object, time, true);
        } else {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                Object fieldValue = ReflectUtil.getFieldValue((Object)object, (Field)field);
                if (field.getName().equals("id") || fieldValue == null) continue;
                ReflectUtil.setFieldValue(objectDB, (Field)field, (Object)fieldValue);
            }
            this.setUpdateTime(objectDB, time);
            this.mongoTemplate.save(objectDB);
            this.logSave(objectDB, time, false);
        }
        return id;
    }

    public String insert(Object object) {
        ReflectUtil.setFieldValue((Object)object, (String)"id", null);
        return this.insertOrUpdate(object);
    }

    public <T> void insertAll(List<T> list) {
        long time = System.currentTimeMillis();
        list.forEach(object -> {
            ReflectUtil.setFieldValue((Object)object, (String)"id", null);
            this.setCreateTime(object, time);
            this.setUpdateTime(object, time);
            this.setInitValue(object);
        });
        this.mongoTemplate.insertAll(list);
        this.logSave(list, time);
    }

    public void updateById(Object object) {
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        if (this.findById(id, object.getClass()) == null) {
            return;
        }
        this.insertOrUpdate(object);
    }

    public void updateAllColumnById(Object object) {
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        if (this.findById(id, object.getClass()) == null) {
            return;
        }
        Long time = System.currentTimeMillis();
        this.setUpdateTime(object, time);
        this.mongoTemplate.save(object);
        this.logSave(object, time, false);
    }

    public void updateFirst(CriteriaWrapper criteriaWrapper, UpdateBuilder updateBuilder, Class<?> clazz) {
        long time = System.currentTimeMillis();
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)updateBuilder.build(), clazz);
        this.logUpdate(clazz, query, updateBuilder, false, time);
    }

    public void updateMulti(CriteriaWrapper criteriaWrapper, UpdateBuilder updateBuilder, Class<?> clazz) {
        long time = System.currentTimeMillis();
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)updateBuilder.build(), clazz);
        this.logUpdate(clazz, query, updateBuilder, true, time);
    }

    public void deleteByQuery(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        long time = System.currentTimeMillis();
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        this.mongoTemplate.remove(query, clazz);
        this.logDelete(clazz, query, time);
    }

    public void deleteById(String id, Class<?> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        this.deleteByQuery(new CriteriaAndWrapper().eq(SatelliteConstant.Mongo::getId, (Object)id), clazz);
    }

    public void deleteByIds(List<String> ids, Class<?> clazz) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        this.deleteByQuery(new CriteriaAndWrapper().in(SatelliteConstant.Mongo::getId, ids), clazz);
    }

    public <T> MongoPage<T> findPage(CriteriaWrapper criteriaWrapper, MongoPage<?> page, Class<T> clazz) {
        SortBuilder sortBuilder = new SortBuilder(SatelliteConstant.Mongo::getId, Sort.Direction.DESC);
        return this.findPage(criteriaWrapper, sortBuilder, page, clazz);
    }

    public <T> MongoPage<T> findPage(CriteriaWrapper criteriaWrapper, SortBuilder sortBuilder, MongoPage<?> page, Class<T> clazz) {
        MongoPage result = new MongoPage();
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        if (page.getSearchCount().booleanValue()) {
            result.setTotal(this.findCountByQuery(criteriaWrapper, clazz));
        }
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        query.with(sortBuilder.build());
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        long time = System.currentTimeMillis();
        List list = this.mongoTemplate.find(query, clazz);
        this.logQuery(clazz, query, time);
        result.setRecords(list);
        return result;
    }

    public <T> MongoPage<T> findPage(SortBuilder sortBuilder, MongoPage<?> page, Class<T> clazz) {
        return this.findPage(new CriteriaAndWrapper(), sortBuilder, page, clazz);
    }

    public <T> MongoPage findPage(MongoPage<?> page, Class<T> clazz) {
        return this.findPage(new CriteriaAndWrapper(), page, clazz);
    }

    public Long findCountByQuery(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        long time = System.currentTimeMillis();
        Long count = null;
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        count = query.getQueryObject().isEmpty() ? Long.valueOf(this.mongoTemplate.getCollection(this.getCollectionName(clazz)).estimatedDocumentCount()) : Long.valueOf(this.mongoTemplate.count(query, clazz));
        this.logCount(clazz, query, time);
        return count;
    }

    public <T> T findById(String id, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        long time = System.currentTimeMillis();
        Object t = this.mongoTemplate.findById((Object)id, clazz);
        this.logQuery(clazz, Query.query((CriteriaDefinition)new CriteriaAndWrapper().eq(SatelliteConstant.Mongo::getId, (Object)id).build()), time);
        return (T)t;
    }

    public <T> T findOne(CriteriaWrapper criteriaWrapper, Class<T> clazz) {
        SortBuilder sortBuilder = new SortBuilder(SatelliteConstant.Mongo::getId, Sort.Direction.DESC);
        return this.findOne(criteriaWrapper, sortBuilder, clazz);
    }

    public <T> T findOne(CriteriaWrapper criteriaWrapper, SortBuilder sortBuilder, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        query.limit(1);
        query.with(sortBuilder.build());
        long time = System.currentTimeMillis();
        Object t = this.mongoTemplate.findOne(query, clazz);
        this.logQuery(clazz, query, time);
        return (T)t;
    }

    public <T> T findOne(SortBuilder sortBuilder, Class<T> clazz) {
        return this.findOne(new CriteriaAndWrapper(), sortBuilder, clazz);
    }

    public <T> List<T> findList(CriteriaWrapper criteriaWrapper, Class<T> clazz) {
        SortBuilder sortBuilder = new SortBuilder(SatelliteConstant.Mongo::getId, Sort.Direction.DESC);
        return this.findList(criteriaWrapper, sortBuilder, clazz);
    }

    public <T> List<T> findList(CriteriaWrapper criteriaWrapper, SortBuilder sortBuilder, Class<T> clazz) {
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        query.with(sortBuilder.build());
        long time = System.currentTimeMillis();
        List list = this.mongoTemplate.find(query, clazz);
        this.logQuery(clazz, query, time);
        return list;
    }

    public <T, R, E> List<E> findProperties(CriteriaWrapper criteriaWrapper, Class<?> clazz, SerializableFunction<T, R> property, Class<E> propertyClass) {
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        query.fields().include(FunctionResolveUtils.resolve(property));
        long time = System.currentTimeMillis();
        List list = this.mongoTemplate.find(query, clazz);
        this.logQuery(clazz, query, time);
        return this.extractProperty(list, FunctionResolveUtils.resolve(property), propertyClass);
    }

    public <T, R> List<String> findProperties(CriteriaWrapper criteriaWrapper, Class<?> clazz, SerializableFunction<T, R> property) {
        return this.findProperties(criteriaWrapper, clazz, property, String.class);
    }

    public <T, R> List<String> findPropertiesByIds(List<String> ids, Class<?> clazz, SerializableFunction<T, R> property) {
        CriteriaWrapper criteriaWrapper = new CriteriaAndWrapper().in(SatelliteConstant.Mongo::getId, ids);
        return this.findProperties(criteriaWrapper, clazz, property, String.class);
    }

    public List<String> findIds(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        return this.findProperties(criteriaWrapper, clazz, SatelliteConstant.Mongo::getId);
    }

    public <T> List<T> findByIds(Collection<String> ids, Class<T> clazz) {
        CriteriaWrapper criteriaWrapper = new CriteriaAndWrapper().in(SatelliteConstant.Mongo::getId, ids);
        return this.findList(criteriaWrapper, clazz);
    }

    public <T> List<T> findByIds(Collection<String> ids, SortBuilder sortBuilder, Class<T> clazz) {
        CriteriaWrapper criteriaWrapper = new CriteriaAndWrapper().in(SatelliteConstant.Mongo::getId, ids);
        return this.findList(criteriaWrapper, sortBuilder, clazz);
    }

    public <T> List<T> findByIds(String[] ids, Class<T> clazz) {
        return this.findByIds(Arrays.asList(ids), clazz);
    }

    public <T> List<T> findByIds(String[] ids, SortBuilder sortBuilder, Class<T> clazz) {
        return this.findByIds(Arrays.asList(ids), sortBuilder, clazz);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findList(new CriteriaAndWrapper(), clazz);
    }

    public <T> List<T> findAll(SortBuilder sortBuilder, Class<T> clazz) {
        return this.findList(new CriteriaAndWrapper(), sortBuilder, clazz);
    }

    public List<String> findAllIds(Class<?> clazz) {
        return this.findIds(new CriteriaAndWrapper(), clazz);
    }

    public Long countAll(Class<?> clazz) {
        return this.findCountByQuery(new CriteriaAndWrapper(), clazz);
    }

    public Long count(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        long time = System.currentTimeMillis();
        Long count = null;
        Query query = new Query((CriteriaDefinition)criteriaWrapper.build());
        count = query.getQueryObject().isEmpty() ? Long.valueOf(this.mongoTemplate.getCollection(this.getCollectionName(clazz)).estimatedDocumentCount()) : Long.valueOf(this.mongoTemplate.count(query, clazz));
        this.logCount(clazz, query, time);
        return count;
    }

    public <T> List<T> extractProperty(List<?> list, String property, Class<T> propertyClazz) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object obj : list) {
            Object value = ReflectUtil.getFieldValue(obj, (String)property);
            if (value == null || !value.getClass().equals(propertyClazz)) continue;
            result.add(value);
        }
        return new ArrayList(result);
    }

    public <T, R> void addCountById(String id, SerializableFunction<T, R> property, Number count, Class<?> clazz) {
        UpdateBuilder updateBuilder = new UpdateBuilder().inc(property, count);
        this.updateFirst(new CriteriaAndWrapper().eq(SatelliteConstant.Mongo::getId, (Object)id), updateBuilder, clazz);
    }

    private void setInitValue(Object object) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(InitValue.class)) continue;
            InitValue initValue = field.getAnnotation(InitValue.class);
            String value = initValue.value();
            if (ReflectUtil.getFieldValue((Object)object, (Field)field) != null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)value);
            }
            if (type.equals(Short.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Short.parseShort(value));
            }
            if (type.equals(Integer.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Integer.parseInt(value));
            }
            if (type.equals(Long.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Long.parseLong(value));
            }
            if (type.equals(Float.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Float.valueOf(Float.parseFloat(value)));
            }
            if (type.equals(Double.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Double.parseDouble(value));
            }
            if (!type.equals(Boolean.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Boolean.parseBoolean(value));
        }
    }

    private void setUpdateTime(Object object, Long time) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(UpdateTime.class) || !field.getType().equals(Date.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)time);
        }
    }

    private void setCreateTime(Object object, Long time) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(CreateTime.class) || !field.getType().equals(Date.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)time);
        }
    }

    private String getCollectionName(Class<?> clazz) {
        Document document = clazz.getAnnotation(Document.class);
        if (document != null) {
            if (StrUtil.isNotEmpty((CharSequence)document.value())) {
                return document.value();
            }
            if (StrUtil.isNotEmpty((CharSequence)document.collection())) {
                return document.collection();
            }
        }
        return StrUtil.lowerFirst((CharSequence)clazz.getSimpleName());
    }

    private void insertSlowQuery(String query, Long queryTime) {
        if (this.slowQuery.booleanValue()) {
            StackTraceElement[] stackTrace;
            SlowQuery slowQuery = new SlowQuery();
            slowQuery.setQuery(query);
            slowQuery.setCreateTime(DateUtil.formatDateTime((Date)new Date()));
            slowQuery.setQueryTime(queryTime);
            slowQuery.setSystem(SystemUtils.getSystem());
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                sb.append(element.getClassName()).append(".").append(element.getMethodName()).append(":").append(element.getLineNumber()).append("\n");
            }
            slowQuery.setStack(sb.toString());
            this.mongoTemplate.insert((Object)slowQuery);
        }
    }

    private void logQuery(Class<?> clazz, Query query, Long startTime) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
        org.bson.Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
        String print = "\n db." + this.getCollectionName(clazz) + ".find(" + mappedQuery.toJson() + ")";
        if (!query.getFieldsObject().isEmpty()) {
            org.bson.Document mappedField = this.queryMapper.getMappedObject((Bson)query.getFieldsObject(), entity);
            print = print + ".projection(" + mappedField.toJson() + ")";
        }
        if (query.isSorted()) {
            org.bson.Document mappedSort = this.queryMapper.getMappedObject((Bson)query.getSortObject(), entity);
            print = print + ".sort(" + mappedSort.toJson() + ")";
        }
        if (query.getLimit() != 0) {
            print = print + ".limit(" + query.getLimit() + ")";
        }
        if (query.getSkip() != 0L) {
            print = print + ".skip(" + query.getSkip() + ")";
        }
        print = print + ";";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }

    private void logCount(Class<?> clazz, Query query, Long startTime) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
        org.bson.Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
        String print = "\ndb." + this.getCollectionName(clazz) + ".find(" + mappedQuery.toJson() + ").count();";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }

    private void logDelete(Class<?> clazz, Query query, Long startTime) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
        org.bson.Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
        String print = "\ndb." + this.getCollectionName(clazz) + ".remove(" + mappedQuery.toJson() + ");";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }

    private void logUpdate(Class<?> clazz, Query query, UpdateBuilder updateBuilder, boolean multi, Long startTime) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
        org.bson.Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
        org.bson.Document mappedUpdate = this.queryMapper.getMappedObject((Bson)updateBuilder.build().getUpdateObject(), entity);
        String print = "\ndb." + this.getCollectionName(clazz) + ".update(" + mappedQuery.toJson() + "," + mappedUpdate.toJson() + ",{multi:" + multi + "});";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }

    private void logSave(Object object, Long startTime, Boolean isInsert) {
        JSONObject jsonObject = JSONUtil.parseObj((Object)object);
        if (isInsert.booleanValue()) {
            jsonObject.remove((Object)"id");
        }
        String print = "\ndb." + this.getCollectionName(object.getClass()) + ".save(" + JSONUtil.toJsonPrettyStr((JSON)jsonObject) + ");";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }

    private void logSave(List<?> list, Long startTime) {
        ArrayList cloneList = new ArrayList();
        list.forEach(item -> {
            JSONObject jsonObject = JSONUtil.parseObj((Object)item);
            jsonObject.remove((Object)"id");
            cloneList.add(jsonObject);
        });
        String print = "db." + this.getCollectionName(list.get(0).getClass()) + ".save(" + JSONUtil.toJsonPrettyStr(cloneList) + ");";
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > this.slowTime) {
            this.insertSlowQuery(print, queryTime);
        }
        if (this.showSql.booleanValue()) {
            log.info(print + "\n\u6267\u884c\u8017\u65f6" + queryTime + "ms");
        }
    }
}

