/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.service;

import cn.hutool.core.util.StrUtil;
import io.gitee.thinkbungee.contant.SatelliteConstant;
import io.gitee.thinkbungee.crud.BaseEntity;
import io.gitee.thinkbungee.crud.PageParam;
import io.gitee.thinkbungee.crud.annotation.Query;
import io.gitee.thinkbungee.crud.mongo.bean.MongoPage;
import io.gitee.thinkbungee.crud.mongo.bean.SortBuilder;
import io.gitee.thinkbungee.crud.mongo.criteria.CriteriaWrapper;
import io.gitee.thinkbungee.crud.mongo.entity.SatelliteMongoEntity;
import io.gitee.thinkbungee.crud.mongo.service.MongoCRUDHelper;
import io.gitee.thinkbungee.crud.mybatis.entity.SatelliteMybatisEntity;
import io.gitee.thinkbungee.enums.BaseOperationEnum;
import io.gitee.thinkbungee.exception.BusinessException;
import io.gitee.thinkbungee.utils.SatelliteUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

public interface SatelliteMongoBaseService<P extends PageParam, T extends BaseEntity> {
    public static final Logger log = LoggerFactory.getLogger(SatelliteMongoBaseService.class);

    public MongoCRUDHelper getMongoCRUDHelper();

    public Class<T> getEntityClass();

    default public void processBeforeOperation(T entity, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processBatchBeforeOperation(List<T> list, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processAfterOperation(T entity, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processBatchAfterOperation(List<T> list, BaseOperationEnum operation) throws BusinessException {
    }

    default public T wrapperEntity(T entity) {
        return entity;
    }

    default public MongoPage<T> resultHandler(MongoPage<T> mongoPage) {
        return mongoPage;
    }

    default public CriteriaWrapper extensionWrapper(P param, CriteriaWrapper wrapper) {
        return wrapper;
    }

    default public CriteriaWrapper handlerQueryWrapper(CriteriaWrapper wrapper) {
        return wrapper;
    }

    default public CriteriaWrapper getWrapper(P param) {
        CriteriaWrapper wrapper = new CriteriaWrapper();
        this.initWrapper(param, wrapper);
        return wrapper;
    }

    default public void initWrapper(P param, CriteriaWrapper wrapper) {
        Field[] fields = param.getClass().getDeclaredFields();
        Arrays.stream(fields).filter(field -> {
            if (field.isAnnotationPresent(Query.class)) {
                Query query = field.getAnnotation(Query.class);
                return query.where();
            }
            return false;
        }).forEach(field -> {
            try {
                boolean flag;
                field.setAccessible(true);
                if (field.get(param) instanceof String) {
                    flag = StrUtil.isNotBlank((CharSequence)((String)field.get(param)));
                } else {
                    boolean bl = flag = field.get(param) != null;
                }
                if (!flag) {
                    return;
                }
                String column = StrUtil.isNotBlank((CharSequence)field.getAnnotation(Query.class).column()) ? field.getAnnotation(Query.class).column() : SatelliteUtils.camelCaseToUnderline(field.getName());
                switch (field.getAnnotation(Query.class).value()) {
                    case LIKE: {
                        String like = String.valueOf(field.get(param));
                        wrapper.like(column, like);
                        break;
                    }
                    case GT: {
                        wrapper.gt(column, field.get(param));
                        break;
                    }
                    case GTE: {
                        wrapper.gte(column, field.get(param));
                        break;
                    }
                    case LT: {
                        wrapper.lt(column, field.get(param));
                        break;
                    }
                    case LTE: {
                        wrapper.lte(column, field.get(param));
                        break;
                    }
                    case IN: {
                        Object value = field.get(param);
                        if (value instanceof List) {
                            wrapper.in(column, (List)value);
                            break;
                        }
                        if (value instanceof String) {
                            Object[] split = String.valueOf(value).split(",");
                            wrapper.in(column, split);
                        }
                        break;
                    }
                    case BETWEEN: {
                        String[] split = String.valueOf(field.get(param)).split(",");
                        if (split.length == 2) {
                            wrapper.gte(column, (Object)split[0]).lte(column, (Object)split[1]);
                            break;
                        }
                        if (split.length == 1) {
                            wrapper.gte(column, (Object)split[0]);
                        }
                        break;
                    }
                    default: {
                        wrapper.eq(column, field.get(param));
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("initWrapper error", (Throwable)e);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    default public String insert(T entity) throws BusinessException {
        this.processBeforeOperation(entity, BaseOperationEnum.INSERT);
        String result = this.getMongoCRUDHelper().insert(entity);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw BusinessException.build(SatelliteConstant.Exception.INSERT_FAILURE);
        }
        this.refreshCacheFields(entity, BaseOperationEnum.INSERT);
        this.processAfterOperation(entity, BaseOperationEnum.INSERT);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public void insertBatch(List<T> entities) throws BusinessException {
        try {
            this.getMongoCRUDHelper().insertAll(entities);
        }
        catch (Exception e) {
            throw BusinessException.build(SatelliteConstant.Exception.INSERT_FAILURE);
        }
        entities.forEach(entity -> this.refreshCacheFields(entity, BaseOperationEnum.INSERT));
    }

    @Transactional(rollbackFor={Exception.class})
    default public void update(T entity) throws BusinessException {
        this.processBeforeOperation(entity, BaseOperationEnum.UPDATE);
        if (entity instanceof SatelliteMybatisEntity) {
            SatelliteMongoEntity mEntity = (SatelliteMongoEntity)entity;
            T dbEntity = this.selectById(mEntity.getId());
            this.refreshCacheFields(dbEntity, BaseOperationEnum.DELETE);
        }
        try {
            this.getMongoCRUDHelper().updateById(entity);
        }
        catch (Exception e) {
            throw BusinessException.build(SatelliteConstant.Exception.UPDATE_FAILURE);
        }
        this.refreshCacheFields(entity, BaseOperationEnum.UPDATE);
        this.processAfterOperation(entity, BaseOperationEnum.UPDATE);
    }

    @Transactional(rollbackFor={Exception.class})
    default public void deleteById(String id) {
        T t = this.selectById(id);
        if (t == null) {
            throw BusinessException.build(SatelliteConstant.Exception.RECORD_NOT_EXIST);
        }
        this.processBeforeOperation(t, BaseOperationEnum.DELETE);
        try {
            this.getMongoCRUDHelper().deleteById(id.toString(), t.getClass());
        }
        catch (Exception e) {
            throw BusinessException.build(SatelliteConstant.Exception.DELETE_FAILURE);
        }
        this.refreshCacheFields(t, BaseOperationEnum.DELETE);
        this.processAfterOperation(t, BaseOperationEnum.DELETE);
    }

    @Transactional(rollbackFor={Exception.class})
    default public void deleteByIds(Collection<String> idList) {
        List<BaseEntity> list = this.getMongoCRUDHelper().findByIds(idList, this.getEntityClass());
        this.processBatchBeforeOperation(list, BaseOperationEnum.DELETE_BATCH);
        this.getMongoCRUDHelper().deleteByIds(new ArrayList<String>(idList), this.getEntityClass());
        list.forEach(t -> this.refreshCacheFields(t, BaseOperationEnum.DELETE_BATCH));
        this.processBatchAfterOperation(list, BaseOperationEnum.DELETE_BATCH);
    }

    @Transactional(rollbackFor={Exception.class})
    default public void delete(CriteriaWrapper criteriaWrapper) {
        this.getMongoCRUDHelper().deleteByQuery(criteriaWrapper, this.getEntityClass());
    }

    default public Long count(CriteriaWrapper wrapper) {
        return this.getMongoCRUDHelper().count(wrapper, this.getEntityClass());
    }

    default public List<T> list(CriteriaWrapper wrapper) {
        return this.getMongoCRUDHelper().findList(wrapper, this.getEntityClass());
    }

    default public List<T> findAll() {
        return this.getMongoCRUDHelper().findAll(this.getEntityClass());
    }

    default public T selectById(String id) {
        return (T)this.wrapperEntity((BaseEntity)this.getMongoCRUDHelper().findById(id, this.getEntityClass()));
    }

    default public T selectOne(CriteriaWrapper wrapper) {
        return (T)this.wrapperEntity((BaseEntity)this.getMongoCRUDHelper().findOne(wrapper, this.getEntityClass()));
    }

    default public MongoPage<T> page(P pageParam) {
        return this.page(pageParam, null);
    }

    default public MongoPage<T> page(P pageParam, CriteriaWrapper wrapper) {
        MongoPage page = new MongoPage();
        page.setCurrent(((PageParam)pageParam).getPageNumber().intValue());
        page.setSize(((PageParam)pageParam).getPageSize().intValue());
        this.orderNew(page, pageParam);
        if (wrapper != null) {
            return this.resultHandler(this.getMongoCRUDHelper().findPage(wrapper, page, this.getEntityClass()));
        }
        CriteriaWrapper queryWrapper = this.extensionWrapper(pageParam, this.getWrapper(pageParam));
        this.handlerQueryWrapper(queryWrapper);
        return this.resultHandler(this.getMongoCRUDHelper().findPage(queryWrapper, page, this.getEntityClass()));
    }

    default public void refreshCacheFields(T entity, BaseOperationEnum operation) {
    }

    default public void orderNew(MongoPage<T> page, P pageParam) {
        String order = ((PageParam)pageParam).getOrder();
        String sort = ((PageParam)pageParam).getSort();
        if (StringUtils.isNotBlank((CharSequence)sort) && StringUtils.isNotBlank((CharSequence)order)) {
            if (sort.contains(",") && order.contains(",")) {
                String[] sortSplit = sort.split(",");
                String[] orderSplit = order.split(",");
                SortBuilder[] sortBuilders = new SortBuilder[sortSplit.length];
                if (sortSplit.length == orderSplit.length) {
                    for (int i = 0; i < orderSplit.length; ++i) {
                        sortBuilders[i] = this.buildOrder(sortSplit[i], orderSplit[i]);
                    }
                } else {
                    String order0 = orderSplit[0];
                    for (int i = 0; i < sortSplit.length; ++i) {
                        sortBuilders[i] = this.buildOrder(sortSplit[i], order0);
                    }
                }
                page.addOrder(sortBuilders);
            }
            if (sort.contains(",") && !order.contains(",")) {
                List<String> orderList = Arrays.stream(sort.split(",")).map(SatelliteUtils::camelCaseToUnderline).collect(Collectors.toList());
                String[] orderColumns = orderList.toArray(new String[0]);
                if ("DESC".equalsIgnoreCase(order)) {
                    page.addOrder(SortBuilder.descs(orderColumns));
                } else {
                    page.addOrder(SortBuilder.ascs(orderColumns));
                }
            }
            if (!sort.contains(",") && !order.contains(",")) {
                page.addOrder(this.buildOrder(sort, order));
            }
        }
    }

    default public SortBuilder buildOrder(String column, String order) {
        SortBuilder sortBuilder = new SortBuilder();
        if ("DESC".equalsIgnoreCase(order)) {
            sortBuilder.add(column, Sort.Direction.DESC);
        } else {
            sortBuilder.add(column, Sort.Direction.ASC);
        }
        return sortBuilder;
    }
}

