/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mongo.utils;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import io.gitee.thinkbungee.crud.mongo.reflection.SerializableFunction;
import java.beans.Introspector;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionResolveUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionResolveUtils.class);
    public static final Map<SerializableFunction<?, ?>, Field> cache = new ConcurrentHashMap();

    public static <T, R> String resolve(SerializableFunction<T, R> function) {
        return FunctionResolveUtils.getField(function).getName();
    }

    public static Field getField(SerializableFunction<?, ?> function) {
        return cache.computeIfAbsent(function, FunctionResolveUtils::findField);
    }

    private static Field findField(SerializableFunction<?, ?> function) {
        Field field = null;
        String fieldName = null;
        try {
            Method method = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(function, new Object[0]);
            String implMethodName = serializedLambda.getImplMethodName();
            if (implMethodName.startsWith("get") && implMethodName.length() > 3) {
                fieldName = Introspector.decapitalize(implMethodName.substring(3));
            } else if (implMethodName.startsWith("is") && implMethodName.length() > 2) {
                fieldName = Introspector.decapitalize(implMethodName.substring(2));
            } else {
                throw new IllegalArgumentException(implMethodName + "\u4e0d\u662fGetter\u65b9\u6cd5\u5f15\u7528");
            }
            String declaredClass = serializedLambda.getImplClass().replace("/", ".");
            Class<?> aClass = Class.forName(declaredClass, false, ClassUtil.getClassLoader());
            field = ReflectUtil.getField(aClass, (String)fieldName);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u51fd\u6570\u5c5e\u6027\u503c\u5931\u8d25", (Throwable)e);
        }
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldError(fieldName);
    }
}

