/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.thinkbungee.crud.mybatis.service;

import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import io.gitee.thinkbungee.contant.SatelliteConstant;
import io.gitee.thinkbungee.crud.BaseEntity;
import io.gitee.thinkbungee.crud.PageParam;
import io.gitee.thinkbungee.crud.annotation.Query;
import io.gitee.thinkbungee.crud.mybatis.annotation.UnionUnique;
import io.gitee.thinkbungee.crud.mybatis.annotation.Unique;
import io.gitee.thinkbungee.crud.mybatis.entity.SatelliteMybatisEntity;
import io.gitee.thinkbungee.crud.mybatis.mapper.SatelliteMybatisMapper;
import io.gitee.thinkbungee.enums.BaseOperationEnum;
import io.gitee.thinkbungee.exception.BusinessException;
import io.gitee.thinkbungee.utils.SatelliteUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public interface SatelliteMybatisBaseService<P extends PageParam, T extends BaseEntity> {
    public static final Logger log = LoggerFactory.getLogger(SatelliteMybatisBaseService.class);

    public SatelliteMybatisMapper<T> getMapper();

    default public void processBeforeOperation(T entity, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processBatchBeforeOperation(List<T> list, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processAfterOperation(T entity, BaseOperationEnum operation) throws BusinessException {
    }

    default public void processBatchAfterOperation(List<T> list, BaseOperationEnum operation) throws BusinessException {
    }

    default public T wrapperEntity(T entity) {
        return entity;
    }

    default public IPage<T> resultHandler(IPage<T> iPage) {
        return iPage;
    }

    default public Wrapper<T> extensionWrapper(P param, QueryWrapper<T> wrapper) {
        return wrapper;
    }

    default public Wrapper<T> handlerQueryWrapper(Wrapper<T> queryWrapper) {
        return queryWrapper;
    }

    default public QueryWrapper<T> getWrapper(P param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.initWrapper(param, queryWrapper);
        return queryWrapper;
    }

    default public void initWrapper(P param, QueryWrapper<T> queryWrapper) {
        Field[] fields = param.getClass().getDeclaredFields();
        Arrays.stream(fields).filter(field -> {
            if (field.isAnnotationPresent(Query.class)) {
                Query query = field.getAnnotation(Query.class);
                return query.where();
            }
            return false;
        }).forEach(field -> {
            try {
                boolean flag;
                field.setAccessible(true);
                if (field.get(param) instanceof String) {
                    flag = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)field.get(param)});
                } else {
                    boolean bl = flag = field.get(param) != null;
                }
                if (!flag) {
                    return;
                }
                String column = StringUtils.isNotBlank((CharSequence)field.getAnnotation(Query.class).column()) ? field.getAnnotation(Query.class).column() : SatelliteUtils.camelCaseToUnderline(field.getName());
                switch (field.getAnnotation(Query.class).value()) {
                    case LIKE: {
                        String like = String.valueOf(field.get(param));
                        if (like.contains("%")) {
                            like = like.replace("%", "\\%");
                        }
                        if (like.contains("_")) {
                            like = like.replace("_", "\\_");
                        }
                        queryWrapper.like((Object)column, (Object)like);
                        break;
                    }
                    case GT: {
                        queryWrapper.gt((Object)column, field.get(param));
                        break;
                    }
                    case GTE: {
                        queryWrapper.ge((Object)column, field.get(param));
                        break;
                    }
                    case LT: {
                        queryWrapper.lt((Object)column, field.get(param));
                        break;
                    }
                    case LTE: {
                        queryWrapper.le((Object)column, field.get(param));
                        break;
                    }
                    case IN: {
                        Object value = field.get(param);
                        if (value instanceof List) {
                            queryWrapper.in((Object)column, (Collection)((List)value));
                            break;
                        }
                        if (value instanceof String) {
                            String[] splits = ((String)value).split(",");
                            queryWrapper.in((Object)column, Arrays.asList(splits));
                        }
                        break;
                    }
                    case BETWEEN: {
                        String[] split = String.valueOf(field.get(param)).split(",");
                        if (split.length == 2) {
                            queryWrapper.between((Object)column, (Object)split[0], (Object)split[1]);
                            break;
                        }
                        if (split.length == 1) {
                            queryWrapper.ge((Object)column, (Object)split[0]);
                        }
                        break;
                    }
                    default: {
                        queryWrapper.eq((Object)column, field.get(param));
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("initWrapper error", (Throwable)e);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer insert(T entity) throws BusinessException {
        this.processBeforeOperation(entity, BaseOperationEnum.INSERT);
        this.checkUniqueField(entity, false);
        Integer result = this.getMapper().insert(entity);
        if (result == null || result < 1) {
            throw BusinessException.build(SatelliteConstant.Exception.INSERT_FAILURE);
        }
        this.refreshCacheFields(entity, BaseOperationEnum.INSERT);
        this.processAfterOperation(entity, BaseOperationEnum.INSERT);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer insertBatch(List<T> entities) throws BusinessException {
        Integer result = this.getMapper().insertBatch(entities);
        entities.forEach(entity -> this.refreshCacheFields(entity, BaseOperationEnum.INSERT));
        if (result == null || result < 1) {
            throw BusinessException.build(SatelliteConstant.Exception.INSERT_FAILURE);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer update(T entity) throws BusinessException {
        Integer result;
        this.processBeforeOperation(entity, BaseOperationEnum.UPDATE);
        this.checkUniqueField(entity, true);
        if (entity instanceof SatelliteMybatisEntity) {
            SatelliteMybatisEntity sEntity = (SatelliteMybatisEntity)entity;
            T dbEntity = this.selectById(sEntity.getId());
            this.refreshCacheFields(dbEntity, BaseOperationEnum.DELETE);
        }
        if ((result = Integer.valueOf(this.getMapper().updateById(entity))) == null || result < 1) {
            throw BusinessException.build(SatelliteConstant.Exception.UPDATE_FAILURE);
        }
        this.refreshCacheFields(entity, BaseOperationEnum.UPDATE);
        this.processAfterOperation(entity, BaseOperationEnum.UPDATE);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public Integer deleteById(Serializable id) {
        T t = this.selectById(id);
        if (t == null) {
            throw BusinessException.build(SatelliteConstant.Exception.RECORD_NOT_EXIST);
        }
        this.processBeforeOperation(t, BaseOperationEnum.DELETE);
        Integer result = this.getMapper().deleteById(id);
        if (result == null || result < 1) {
            throw BusinessException.build(SatelliteConstant.Exception.DELETE_FAILURE);
        }
        this.refreshCacheFields(t, BaseOperationEnum.DELETE);
        this.processAfterOperation(t, BaseOperationEnum.DELETE);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public boolean deleteByIds(Collection<? extends Serializable> idList) {
        List list = this.getMapper().selectBatchIds(idList);
        this.processBatchBeforeOperation(list, BaseOperationEnum.DELETE_BATCH);
        boolean result = SqlHelper.retBool((Integer)this.getMapper().deleteBatchIds(idList));
        if (result) {
            list.forEach(t -> this.refreshCacheFields(t, BaseOperationEnum.DELETE_BATCH));
            this.processBatchAfterOperation(list, BaseOperationEnum.DELETE_BATCH);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    default public void delete(LambdaQueryWrapper<T> lambdaQueryWrapper) {
        this.getMapper().delete((Wrapper)lambdaQueryWrapper);
    }

    default public Integer count(Wrapper<T> wrapper) {
        return this.getMapper().selectCount(wrapper);
    }

    default public List<T> list(Wrapper<T> wrapper) {
        return this.getMapper().selectList(wrapper);
    }

    default public List<T> findAll() {
        return this.getMapper().selectList((Wrapper)Wrappers.emptyWrapper());
    }

    default public T selectById(Serializable id) {
        return (T)this.wrapperEntity((BaseEntity)this.getMapper().selectById(id));
    }

    default public T selectOne(Wrapper<T> wrapper) {
        return (T)this.wrapperEntity((BaseEntity)this.getMapper().selectOne(wrapper));
    }

    default public IPage<T> page(P pageParam) {
        return this.page(pageParam, null);
    }

    default public IPage<T> page(P pageParam, Wrapper<T> wrapper) {
        Page page = new Page();
        page.setCurrent((long)((PageParam)pageParam).getPageNumber().intValue());
        page.setSize((long)((PageParam)pageParam).getPageSize().intValue());
        this.orderNew(page, pageParam);
        if (wrapper != null) {
            return this.resultHandler(this.getMapper().selectPage((IPage)page, wrapper));
        }
        Wrapper<T> queryWrapper = this.extensionWrapper(pageParam, this.getWrapper(pageParam));
        this.handlerQueryWrapper(queryWrapper);
        return this.resultHandler(this.getMapper().selectPage((IPage)page, queryWrapper));
    }

    default public void refreshCacheFields(T entity, BaseOperationEnum operation) {
    }

    default public void checkUniqueField(T entity, boolean isUpdate) {
        Field[] allFields = ReflectUtil.getFields(entity.getClass());
        Optional<Field> idFiledOptional = Arrays.stream(allFields).filter(f -> f.isAnnotationPresent(TableId.class)).findFirst();
        if (!idFiledOptional.isPresent()) {
            return;
        }
        Field idField = idFiledOptional.get();
        idField.setAccessible(true);
        for (Field field : allFields) {
            Integer result;
            if (!field.isAnnotationPresent(Unique.class)) continue;
            Unique unique = field.getDeclaredAnnotation(Unique.class);
            try {
                Object value = ReflectUtil.getFieldValue(entity, (Field)field);
                String column = StringUtils.isBlank((CharSequence)unique.column()) ? SatelliteUtils.camelCaseToUnderline(field.getName()) : unique.column();
                QueryWrapper queryWrapper = Wrappers.query();
                queryWrapper.eq((Object)column, value);
                if (isUpdate) {
                    queryWrapper.ne((Object)idField.getAnnotation(TableId.class).value(), ReflectUtil.getFieldValue(entity, (Field)idField));
                }
                result = this.getMapper().selectCount((Wrapper)queryWrapper);
            }
            catch (Exception e) {
                continue;
            }
            if (result <= 0) continue;
            throw BusinessException.build(unique.code(), field.getName());
        }
        HashMap<String, QueryWrapper> unionUniqueMap = new HashMap<String, QueryWrapper>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(UnionUnique.class)) continue;
            try {
                UnionUnique[] unionUniques;
                for (UnionUnique uu : unionUniques = (UnionUnique[])field.getDeclaredAnnotationsByType(UnionUnique.class)) {
                    QueryWrapper queryWrapper;
                    String group = uu.group();
                    Object value = ReflectUtil.getFieldValue(entity, (Field)field);
                    String column = StringUtils.isBlank((CharSequence)uu.column()) ? SatelliteUtils.camelCaseToUnderline(field.getName()) : uu.column();
                    if (unionUniqueMap.containsKey(group)) {
                        queryWrapper = (QueryWrapper)unionUniqueMap.get(group);
                        queryWrapper.eq((Object)column, value);
                        continue;
                    }
                    queryWrapper = Wrappers.query();
                    queryWrapper.eq((Object)column, value);
                    unionUniqueMap.put(group, queryWrapper);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (CollectionUtils.isEmpty(unionUniqueMap)) {
            return;
        }
        Set entries = unionUniqueMap.entrySet();
        for (Map.Entry entry : entries) {
            Integer result;
            QueryWrapper queryWrapper = (QueryWrapper)entry.getValue();
            if (isUpdate) {
                try {
                    queryWrapper.ne((Object)idField.getAnnotation(TableId.class).value(), idField.get(entity));
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if ((result = this.getMapper().selectCount((Wrapper)queryWrapper)) <= 0) continue;
            String msg = entity.getClass().getName() + " " + (String)entry.getKey() + " unionUnique error";
            throw BusinessException.build(msg, new Object[0]);
        }
    }

    default public void order(Page<T> page, P pageParam) {
        String sort = ((PageParam)pageParam).getSort();
        if (StringUtils.equals((CharSequence)"ASC", (CharSequence)((PageParam)pageParam).getOrder()) && StringUtils.isNotEmpty((CharSequence)((PageParam)pageParam).getSort())) {
            if (sort.contains(",")) {
                page.addOrder(OrderItem.ascs((String[])sort.split(",")));
            } else {
                page.addOrder(new OrderItem[]{OrderItem.asc((String)sort)});
            }
        } else if (StringUtils.equals((CharSequence)"DESC", (CharSequence)((PageParam)pageParam).getOrder()) && StringUtils.isNotEmpty((CharSequence)((PageParam)pageParam).getSort())) {
            if (sort.contains(",")) {
                page.addOrder(OrderItem.descs((String[])sort.split(",")));
            } else {
                page.addOrder(new OrderItem[]{OrderItem.desc((String)sort)});
            }
        }
    }

    default public void orderNew(Page<T> page, P pageParam) {
        String order = ((PageParam)pageParam).getOrder();
        String sort = ((PageParam)pageParam).getSort();
        if (StringUtils.isNotBlank((CharSequence)sort) && StringUtils.isNotBlank((CharSequence)order)) {
            if (sort.contains(",") && order.contains(",")) {
                String[] sortSplit = sort.split(",");
                String[] orderSplit = order.split(",");
                OrderItem[] orderItems = new OrderItem[sortSplit.length];
                if (sortSplit.length == orderSplit.length) {
                    for (int i = 0; i < orderSplit.length; ++i) {
                        orderItems[i] = this.buildOrder(SatelliteUtils.camelCaseToUnderline(sortSplit[i]), orderSplit[i]);
                    }
                } else {
                    String order0 = orderSplit[0];
                    for (int i = 0; i < sortSplit.length; ++i) {
                        orderItems[i] = this.buildOrder(SatelliteUtils.camelCaseToUnderline(sortSplit[i]), order0);
                    }
                }
                page.addOrder(orderItems);
            }
            if (sort.contains(",") && !order.contains(",")) {
                List<String> orderList = Arrays.stream(sort.split(",")).map(SatelliteUtils::camelCaseToUnderline).collect(Collectors.toList());
                String[] orderColumns = orderList.toArray(new String[0]);
                if ("DESC".equalsIgnoreCase(order)) {
                    page.addOrder(OrderItem.descs((String[])orderColumns));
                } else {
                    page.addOrder(OrderItem.ascs((String[])orderColumns));
                }
            }
            if (!sort.contains(",") && !order.contains(",")) {
                page.addOrder(new OrderItem[]{this.buildOrder(SatelliteUtils.camelCaseToUnderline(sort), order)});
            }
        }
    }

    default public OrderItem buildOrder(String column, String order) {
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn(column);
        if ("DESC".equalsIgnoreCase(order)) {
            orderItem.setAsc(false);
        }
        return orderItem;
    }
}

