package arp.message.rocketmq;

import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;

import arp.process.publish.ProcessMessageSender;

public class RocketmqMessageSender implements ProcessMessageSender {

	private final DefaultMQProducer producer;

	private RocketmqMessageSerializationStrategy serializationStrategy;

	public RocketmqMessageSender(String producerGroup, String namesrvAddr)
			throws Exception {
		this(producerGroup, namesrvAddr, new FSTSerializationStrategy());
	}

	public RocketmqMessageSender(String producerGroup, String namesrvAddr,
			RocketmqMessageSerializationStrategy serializationStrategy)
			throws Exception {
		this.serializationStrategy = serializationStrategy;
		// 实例化消息生产者Producer
		producer = new DefaultMQProducer(producerGroup);
		// 设置NameServer的地址
		producer.setNamesrvAddr(namesrvAddr);
		// 启动Producer实例
		producer.start();
	}

	@Override
	public void send(arp.process.publish.Message msg) throws Exception {

		// 创建消息，并指定Topic，Tag和消息体
		Message rmqMsg = new Message("arp_process_message", "no_tag",
				serializationStrategy.serialize(msg));
		// 发送单向消息，没有任何返回结果
		producer.sendOneway(rmqMsg);

	}

}
