/*
 * Decompiled with CFR 0.152.
 */
package arp.message.rocketmq;

import arp.message.rocketmq.FSTSerializationStrategy;
import arp.message.rocketmq.RocketmqMessageSerializationStrategy;
import arp.process.publish.ProcessMessageSender;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;

public class RocketmqMessageSender
implements ProcessMessageSender {
    private final DefaultMQProducer producer;
    private RocketmqMessageSerializationStrategy serializationStrategy;

    public RocketmqMessageSender(String producerGroup, String namesrvAddr) throws Exception {
        this(producerGroup, namesrvAddr, new FSTSerializationStrategy());
    }

    public RocketmqMessageSender(String producerGroup, String namesrvAddr, RocketmqMessageSerializationStrategy serializationStrategy) throws Exception {
        this.serializationStrategy = serializationStrategy;
        this.producer = new DefaultMQProducer(producerGroup);
        this.producer.setNamesrvAddr(namesrvAddr);
        this.producer.start();
    }

    public void send(arp.process.publish.Message msg) throws Exception {
        Message rmqMsg = new Message("arp_process_message", "no_tag", this.serializationStrategy.serialize(msg));
        this.producer.sendOneway(rmqMsg);
    }
}

