package arp.message.rocketmq;

import java.io.ByteArrayInputStream;

import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;

import arp.process.publish.Message;

public class FSTDeserializationStrategy implements
		RocketmqMessageDeserializationStrategy {

	private FSTConfiguration fstConf;

	public FSTDeserializationStrategy() {
		fstConf = FSTConfiguration.createJsonConfiguration();
		fstConf.setForceSerializable(true);
	}

	@Override
	public Message deserialize(byte[] body) throws Exception {
		FSTObjectInput ois = fstConf.getObjectInput(new ByteArrayInputStream(
				body));
		return (Message) ois.readObject();
	}
}
