package arp.message.rocketmq;

import arp.process.publish.Message;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectOutput;

import java.io.ByteArrayOutputStream;

public class FSTSerializationStrategy implements
        RocketmqMessageSerializationStrategy {

    private FSTConfiguration fstConf;

    public FSTSerializationStrategy() {
        fstConf = FSTConfiguration.createJsonConfiguration();
        fstConf.setForceSerializable(true);
    }


    @Override
    public byte[] serialize(Message message) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FSTObjectOutput oos = fstConf.getObjectOutput(bos);
        oos.writeObject(message);
        oos.flush();
        return bos.toByteArray();
    }

}
