package arp.message.kafka;

import java.io.ByteArrayInputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;

import arp.process.publish.Message;
import arp.process.publish.ProcessListenerMessageReceiver;

public class KafkaMessageReceiver implements ProcessListenerMessageReceiver {

	FSTConfiguration fstConf;

	private KafkaConsumer<String, byte[]> consumer;

	public KafkaMessageReceiver(String servers, String consumerGroup) {
		fstConf = FSTConfiguration.createDefaultConfiguration();
		fstConf.setForceSerializable(true);

		Properties props = new Properties();
		props.put(ConsumerConfig.BOOTSTRAP_SERVERS_CONFIG, servers);
		props.put(ConsumerConfig.GROUP_ID_CONFIG, consumerGroup);
		props.put(ConsumerConfig.KEY_DESERIALIZER_CLASS_CONFIG, StringDeserializer.class);
		props.put(ConsumerConfig.VALUE_DESERIALIZER_CLASS_CONFIG, ByteArrayDeserializer.class);
		consumer = new KafkaConsumer<>(props);
	}

	@Override
	public List<Message> receive() throws Exception {
		List<Message> messageList = new ArrayList<>();
		ConsumerRecords<String, byte[]> records = consumer.poll(Duration.ofMillis(100));
		for (ConsumerRecord<String, byte[]> record : records) {
			byte[] msg = record.value();
			FSTObjectInput ois = fstConf.getObjectInput(new ByteArrayInputStream(msg));
			messageList.add((Message) ois.readObject());
		}
		return messageList;
	}

	@Override
	public void subscribeProcesses(List<String> processesToSubscribe) {
		if (processesToSubscribe != null) {
			consumer.subscribe(processesToSubscribe);
		}
	}

}
