/*
 * Decompiled with CFR 0.152.
 */
package arp.message.kafka;

import arp.process.publish.MonitorMessage;
import arp.process.publish.ProcessesMonitor;
import com.google.gson.Gson;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.StringDeserializer;

public class KafkaProcessesMonitor
extends ProcessesMonitor {
    private Gson gson = new Gson();
    private KafkaConsumer<String, String> consumer;
    private AdminClient adminClient;
    private boolean emptySubscription;
    private String monitorTopicPrefix;

    public KafkaProcessesMonitor(String servers, String consumerGroup, String monitorTopicPrefix) {
        this.monitorTopicPrefix = monitorTopicPrefix;
        Properties props = new Properties();
        props.put("bootstrap.servers", servers);
        props.put("group.id", consumerGroup);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        this.consumer = new KafkaConsumer(props);
        Properties pro = new Properties();
        pro.put("bootstrap.servers", servers);
        this.adminClient = KafkaAdminClient.create((Properties)pro);
    }

    protected void subscribeProcesses(List<String> processesToSubscribe) {
        if (processesToSubscribe != null && !processesToSubscribe.isEmpty()) {
            ArrayList<String> topics = new ArrayList<String>();
            for (String process : processesToSubscribe) {
                topics.add(this.monitorTopicPrefix + process);
            }
            this.consumer.subscribe(topics);
            this.emptySubscription = false;
        } else {
            this.emptySubscription = true;
        }
    }

    protected List<String> queryAllProcessesToSubscribe() {
        ListTopicsResult result = this.adminClient.listTopics();
        KafkaFuture set = result.names();
        try {
            Set topicsSet = (Set)set.get();
            ArrayList<String> rslt = new ArrayList<String>();
            for (String topic : topicsSet) {
                rslt.add(topic);
            }
            return rslt;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<MonitorMessage> receive() throws Exception {
        ArrayList<MonitorMessage> messageList = new ArrayList<MonitorMessage>();
        if (this.emptySubscription) {
            return messageList;
        }
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(100L));
        for (ConsumerRecord record : records) {
            String msg = (String)record.value();
            messageList.add((MonitorMessage)this.gson.fromJson(msg, MonitorMessage.class));
        }
        return messageList;
    }
}

