/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.springdatamongodb;

import arp.repository.springdatamongodb.MongodbRepository;
import arp.util.Unsafe;
import java.lang.reflect.Field;
import org.springframework.data.mongodb.core.MongoTemplate;

public class CommonMongodbRepository<E>
extends MongodbRepository<E, Object> {
    private Class<E> cls;
    private Class<?> idFieldType;
    private long idFieldOffset;

    public CommonMongodbRepository(MongoTemplate mongoTemplate, Class<E> cls) {
        super(mongoTemplate);
        this.cls = cls;
        try {
            Field idField = cls.getDeclaredField("id");
            this.idFieldType = idField.getType();
            this.idFieldOffset = Unsafe.getFieldOffset((Field)idField);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Class<E> getEntityClass() {
        return this.cls;
    }

    protected Object getId(E entity) {
        try {
            if (Byte.TYPE.equals(this.idFieldType)) {
                return Unsafe.getByteFieldOfObject(entity, (long)this.idFieldOffset);
            }
            if (Short.TYPE.equals(this.idFieldType)) {
                return Unsafe.getShortFieldOfObject(entity, (long)this.idFieldOffset);
            }
            if (Character.TYPE.equals(this.idFieldType)) {
                return Character.valueOf(Unsafe.getCharFieldOfObject(entity, (long)this.idFieldOffset));
            }
            if (Integer.TYPE.equals(this.idFieldType)) {
                return Unsafe.getIntFieldOfObject(entity, (long)this.idFieldOffset);
            }
            if (Float.TYPE.equals(this.idFieldType)) {
                return Float.valueOf(Unsafe.getFloatFieldOfObject(entity, (long)this.idFieldOffset));
            }
            if (Long.TYPE.equals(this.idFieldType)) {
                return Unsafe.getLongFieldOfObject(entity, (long)this.idFieldOffset);
            }
            if (Double.TYPE.equals(this.idFieldType)) {
                return Unsafe.getDoubleFieldOfObject(entity, (long)this.idFieldOffset);
            }
            if (Boolean.TYPE.equals(this.idFieldType)) {
                return Unsafe.getBooleanFieldOfObject(entity, (long)this.idFieldOffset);
            }
            return Unsafe.getObjectFieldOfObject(entity, (long)this.idFieldOffset);
        }
        catch (Exception e) {
            return null;
        }
    }
}

