/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.springdatamongodb;

import arp.repository.SimplePersistenceRepository;
import org.springframework.data.mongodb.core.MongoTemplate;

public abstract class SimpleMappedMongodbRepository<E, DTO, ID>
extends SimplePersistenceRepository<E, ID> {
    private MongoTemplate mongoTemplate;

    protected SimpleMappedMongodbRepository(MongoTemplate mongoTemplate) {
        if (mongoTemplate == null) {
            this.initAsMock();
        } else {
            this.mongoTemplate = mongoTemplate;
        }
    }

    protected void updateImpl(ID id, E entity) {
        DTO dto = this.toDTO(entity);
        this.mongoTemplate.save(dto);
    }

    protected abstract DTO toDTO(E var1);

    protected E findByIdImpl(ID id) {
        Object dto = this.mongoTemplate.findById(id, this.getDtoClass());
        if (dto == null) {
            return null;
        }
        return this.toEntity(dto);
    }

    protected abstract E toEntity(DTO var1);

    protected abstract Class<DTO> getDtoClass();

    protected void saveImpl(ID id, E entity) {
        DTO dto = this.toDTO(entity);
        this.mongoTemplate.save(dto);
    }

    protected void removeImpl(ID id) {
        Object dto = this.mongoTemplate.findById(id, this.getDtoClass());
        if (dto == null) {
            return;
        }
        this.mongoTemplate.remove(dto);
    }
}

