/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.springdatamongodb;

import arp.repository.PersistenceRepository;
import arp.repository.springdatamongodb.CanNotAcquireLockException;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class MappedMongodbRepository<E, DTO, I>
extends PersistenceRepository<E, I> {
    protected MongoTemplate mongoTemplate;
    int lockRetryCount = 300;

    protected MappedMongodbRepository(MongoTemplate mongoTemplate) {
        if (mongoTemplate == null) {
            this.initAsMock();
        } else {
            this.mongoTemplate = mongoTemplate;
        }
    }

    protected abstract E toEntity(DTO var1);

    protected abstract Class<DTO> getDtoClass();

    protected abstract DTO toDTO(E var1);

    protected E findByIdForUpdateImpl(I id) {
        boolean hasLock = this.acquireLock(id);
        if (!hasLock) {
            return null;
        }
        return this.findByIdImpl(id);
    }

    private void createLock(I id) {
        Class<DTO> dtoCls = this.getDtoClass();
        String collectionName = "arp_repo_state_" + dtoCls.getSimpleName();
        HashMap<String, Object> lock = new HashMap<String, Object>();
        lock.put("_id", id);
        lock.put("state", 1);
        try {
            this.mongoTemplate.insert(lock, collectionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean acquireLock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id).and("state").is((Object)0));
        Update update = new Update();
        update.set("state", (Object)1);
        Class<DTO> dtoCls = this.getDtoClass();
        String collectionName = "arp_repo_state_" + dtoCls.getSimpleName();
        int counter = this.lockRetryCount;
        while (true) {
            UpdateResult updateResult;
            if ((updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName)).getModifiedCount() > 0L) {
                return true;
            }
            if (updateResult.getMatchedCount() == 0L) {
                Query checkQuery = new Query();
                checkQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
                boolean exists = this.mongoTemplate.exists(checkQuery, dtoCls);
                if (!exists) {
                    return false;
                }
                this.createLock(id);
                return true;
            }
            if (counter > 200) {
                --counter;
                continue;
            }
            if (counter > 100) {
                --counter;
                Thread.yield();
                continue;
            }
            if (counter <= 0) break;
            --counter;
            LockSupport.parkNanos(1L);
        }
        throw new CanNotAcquireLockException();
    }

    protected E findByIdImpl(I id) {
        Object dto = this.mongoTemplate.findById(id, this.getDtoClass());
        if (dto == null) {
            return null;
        }
        return this.toEntity(dto);
    }

    protected E saveIfAbsentImpl(I id, E entity) {
        DTO dto = this.toDTO(entity);
        try {
            this.mongoTemplate.insert(dto);
            this.createLock(id);
            return null;
        }
        catch (Exception e) {
            while (!this.acquireLock(id)) {
            }
            return this.findByIdImpl(id);
        }
    }

    protected void updateBatchImpl(Map<I, E> entitiesToUpdate) {
        entitiesToUpdate.forEach((id, ett) -> this.updateImpl(id, ett));
    }

    protected void updateImpl(I id, E entity) {
        this.mongoTemplate.save(this.toDTO(entity));
    }

    private void unlock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Update update = new Update();
        update.set("state", (Object)0);
        Class<DTO> dtoCls = this.getDtoClass();
        String collectionName = "arp_repo_state_" + dtoCls.getSimpleName();
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
    }

    protected void saveBatchImpl(Map<I, E> entities) {
        ArrayList dtos = new ArrayList();
        entities.values().forEach(ett -> dtos.add(this.toDTO(ett)));
        this.mongoTemplate.insert(dtos, this.getDtoClass());
    }

    protected void saveImpl(I id, E entity) {
        this.mongoTemplate.save(this.toDTO(entity));
    }

    protected void removeBatchImpl(Set<I> ids) {
        ids.forEach(id -> this.removeImpl(id));
    }

    protected void removeImpl(I id) {
        Object dto = this.mongoTemplate.findById(id, this.getDtoClass());
        if (dto != null) {
            this.mongoTemplate.remove(dto);
            this.removeLock(id);
        }
    }

    private void removeLock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Class<DTO> dtoCls = this.getDtoClass();
        String collectionName = "arp_repo_state_" + dtoCls.getSimpleName();
        this.mongoTemplate.remove(query, collectionName);
    }

    protected void unlockBatchImpl(Set<I> ids) {
        ids.forEach(id -> this.unlockImpl(id));
    }

    protected void unlockImpl(I id) {
        this.unlock(id);
    }

    public I findMaxId() {
        if (this.mongoTemplate == null) {
            return null;
        }
        Query query = new Query();
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(1);
        Object maxDto = this.mongoTemplate.findOne(query, this.getDtoClass());
        if (maxDto == null) {
            return null;
        }
        return (I)this.getId(this.toEntity(maxDto));
    }

    public List<E> findAllByField(String fieldName, Object fieldValue) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)fieldName).is(fieldValue));
        List dtos = this.mongoTemplate.find(query, this.getDtoClass());
        ArrayList<E> etts = new ArrayList<E>();
        for (Object dto : dtos) {
            etts.add(this.toEntity(dto));
        }
        return etts;
    }
}

