/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.springdatamongodb;

import arp.repository.SimplePersistenceRepository;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class SimpleMongodbRepository<E, I>
extends SimplePersistenceRepository<E, I> {
    protected MongoTemplate mongoTemplate;

    protected SimpleMongodbRepository(MongoTemplate mongoTemplate) {
        if (mongoTemplate == null) {
            this.initAsMock();
        } else {
            this.mongoTemplate = mongoTemplate;
        }
    }

    protected void updateImpl(I id, E entity) {
        this.mongoTemplate.save(entity);
    }

    protected E findByIdImpl(I id) {
        return (E)this.mongoTemplate.findById(id, this.getEntityClass());
    }

    protected abstract Class<E> getEntityClass();

    protected void saveImpl(I id, E entity) {
        this.mongoTemplate.save(entity);
    }

    protected void removeImpl(I id) {
        Object entity = this.mongoTemplate.findById(id, this.getEntityClass());
        if (entity == null) {
            return;
        }
        this.mongoTemplate.remove(entity);
    }

    public List<E> findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    public I findMaxId() {
        if (this.mongoTemplate == null) {
            return null;
        }
        Query query = new Query();
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(1);
        Object maxEtt = this.mongoTemplate.findOne(query, this.getEntityClass());
        if (maxEtt == null) {
            return null;
        }
        return (I)this.getId(maxEtt);
    }

    public List<E> findAllByField(String fieldName, Object fieldValue) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)fieldName).is(fieldValue));
        return this.mongoTemplate.find(query, this.getEntityClass());
    }
}

