/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.springdatamongodb;

import arp.repository.PersistenceRepository;
import arp.repository.springdatamongodb.CanNotAcquireLockException;
import com.mongodb.client.result.UpdateResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class MongodbRepository<E, I>
extends PersistenceRepository<E, I> {
    protected MongoTemplate mongoTemplate;
    int lockRetryCount = 300;

    protected MongodbRepository(MongoTemplate mongoTemplate) {
        if (mongoTemplate == null) {
            this.initAsMock();
        } else {
            this.mongoTemplate = mongoTemplate;
        }
    }

    private boolean createLock(I id) {
        Class<E> ettCls = this.getEntityClass();
        String collectionName = "arp_repo_state_" + ettCls.getSimpleName();
        HashMap<String, Object> lock = new HashMap<String, Object>();
        lock.put("_id", id);
        lock.put("state", 1);
        try {
            this.mongoTemplate.insert(lock, collectionName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected E findByIdForUpdateImpl(I id) {
        boolean hasEntity = this.acquireLock(id);
        if (!hasEntity) {
            return null;
        }
        return this.findByIdImpl(id);
    }

    private boolean acquireLock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id).and("state").is((Object)0));
        Update update = new Update();
        update.set("state", (Object)1);
        Class<E> ettCls = this.getEntityClass();
        String collectionName = "arp_repo_state_" + ettCls.getSimpleName();
        int counter = this.lockRetryCount;
        while (true) {
            UpdateResult updateResult;
            if ((updateResult = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName)).getModifiedCount() > 0L) {
                return true;
            }
            Query lockExistsCheckQuery = new Query();
            lockExistsCheckQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
            boolean lockExists = this.mongoTemplate.exists(lockExistsCheckQuery, collectionName);
            if (!lockExists) {
                Query entityExistsCheckQuery = new Query();
                entityExistsCheckQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
                boolean entityExists = this.mongoTemplate.exists(entityExistsCheckQuery, ettCls);
                if (!entityExists) {
                    return false;
                }
                if (!this.createLock(id)) continue;
                return true;
            }
            if (counter > 200) {
                --counter;
                continue;
            }
            if (counter > 100) {
                --counter;
                Thread.yield();
                continue;
            }
            if (counter <= 0) break;
            --counter;
            LockSupport.parkNanos(1L);
        }
        throw new CanNotAcquireLockException();
    }

    protected abstract Class<E> getEntityClass();

    protected E findByIdImpl(I id) {
        return (E)this.mongoTemplate.findById(id, this.getEntityClass());
    }

    protected E saveIfAbsentImpl(I id, E entity) {
        try {
            this.mongoTemplate.insert(entity);
            if (this.createLock(id)) {
                return null;
            }
            while (!this.acquireLock(id)) {
            }
            return this.findByIdImpl(id);
        }
        catch (Exception e) {
            while (!this.acquireLock(id)) {
            }
            return this.findByIdImpl(id);
        }
    }

    protected void updateBatchImpl(Map<I, E> entitiesToUpdate) {
        entitiesToUpdate.forEach((id, ett) -> this.updateImpl(id, ett));
    }

    protected void updateImpl(I id, E entity) {
        this.mongoTemplate.save(entity);
    }

    protected void unlock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Update update = new Update();
        update.set("state", (Object)0);
        Class<E> ettCls = this.getEntityClass();
        String collectionName = "arp_repo_state_" + ettCls.getSimpleName();
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
    }

    protected void saveBatchImpl(Map<I, E> entities) {
        this.mongoTemplate.insert(entities.values(), this.getEntityClass());
    }

    protected void saveImpl(I id, E entity) {
        this.mongoTemplate.save(entity);
    }

    protected void removeBatchImpl(Set<I> ids) {
        ids.forEach(id -> this.removeImpl(id));
    }

    protected void removeImpl(I id) {
        E ett = this.findByIdImpl(id);
        if (ett != null) {
            this.mongoTemplate.remove(ett);
            this.removeLock(id);
        }
    }

    private void removeLock(I id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        Class<E> ettCls = this.getEntityClass();
        String collectionName = "arp_repo_state_" + ettCls.getSimpleName();
        this.mongoTemplate.remove(query, collectionName);
    }

    protected void unlockBatchImpl(Set<I> ids) {
        ids.forEach(id -> this.unlockImpl(id));
    }

    protected void unlockImpl(I id) {
        this.unlock(id);
    }

    public I findMaxId() {
        if (this.mongoTemplate == null) {
            return null;
        }
        Query query = new Query();
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(1);
        Object maxEtt = this.mongoTemplate.findOne(query, this.getEntityClass());
        if (maxEtt == null) {
            return null;
        }
        return (I)this.getId(maxEtt);
    }

    public List<E> findAllByField(String fieldName, Object fieldValue) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)fieldName).is(fieldValue));
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    public List<E> findAll() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }
}

