package arp.repository.springdatamongodb;

import org.springframework.data.mongodb.core.MongoTemplate;

import arp.repository.SimplePersistenceRepository;

public abstract class SimpleMappedMongodbRepository<E, DTO, ID> extends
		SimplePersistenceRepository<E, ID> {

	private MongoTemplate mongoTemplate;

	protected SimpleMappedMongodbRepository(MongoTemplate mongoTemplate) {
		if (mongoTemplate == null) {
			initAsMock();
		} else {
			this.mongoTemplate = mongoTemplate;
		}
	}

	@Override
	protected void updateImpl(ID id, E entity) {
		DTO dto = toDTO(entity);
		mongoTemplate.save(dto);
	}

	protected abstract DTO toDTO(E entity);

	@Override
	protected E findByIdImpl(ID id) {
		DTO dto = mongoTemplate.findById(id, getDtoClass());
		if (dto == null) {
			return null;
		}
		return toEntity(dto);
	}

	protected abstract E toEntity(DTO dto);

	protected abstract Class<DTO> getDtoClass();

	@Override
	protected void saveImpl(ID id, E entity) {
		DTO dto = toDTO(entity);
		mongoTemplate.save(dto);
	}

	@Override
	protected void removeImpl(ID id) {
		DTO dto = mongoTemplate.findById(id, getDtoClass());
		if (dto == null) {
			return;
		}
		mongoTemplate.remove(dto);
	}

}
