/*
 * Decompiled with CFR 0.152.
 */
package arp;

import arp.enhance.ClassEnhancer;
import arp.enhance.ClassParseResult;
import arp.enhance.ListenerInfo;
import arp.enhance.ProcessInfo;
import arp.process.publish.MessageSender;
import arp.process.publish.MonitorMessageConvertor;
import arp.process.publish.ProcessListenerMessageConsumer;
import arp.process.publish.ProcessListenerMessageProcessor;
import arp.process.publish.ProcessListenerMessageReceiver;
import arp.process.publish.ProcessPublisher;
import java.util.ArrayList;
import java.util.List;

public class ARP {
    private static ProcessListenerMessageConsumer messageConsumer;

    public static void start(String ... pkgs) throws Exception {
        ClassEnhancer.parseAndEnhance(pkgs);
    }

    public static void start(MessageSender messageSender, String ... pkgs) throws Exception {
        ClassParseResult parseResult = ClassEnhancer.parseAndEnhance(pkgs);
        List<String> processesToPublish = ARP.getProcessesToSend(parseResult);
        ProcessPublisher.messageSender = messageSender;
        ProcessPublisher.defineProcessesToPublish(processesToPublish);
    }

    public static void start(ProcessListenerMessageReceiver messageReceiver, String ... pkgs) throws Exception {
        ClassParseResult parseResult = ClassEnhancer.parseAndEnhance(pkgs);
        List<String> processesToSubscribe = ARP.getProcessesToSubscribe(parseResult);
        messageConsumer = new ProcessListenerMessageConsumer();
        messageConsumer.start(processesToSubscribe, messageReceiver);
    }

    private static List<String> getProcessesToSubscribe(ClassParseResult parseResult) {
        if (parseResult == null) {
            return null;
        }
        List<ProcessInfo> processInfoList = parseResult.getProcessInfoList();
        ArrayList<String> processesToSubscribe = new ArrayList<String>();
        for (ProcessInfo processInfo : processInfoList) {
            ListenerInfo listenerInfo = processInfo.getListenerInfo();
            if (listenerInfo == null) continue;
            String processDesc = listenerInfo.getProcessDesc();
            processesToSubscribe.add(processDesc);
        }
        return processesToSubscribe;
    }

    public static void start(MessageSender messageSender, ProcessListenerMessageReceiver messageReceiver, String ... pkgs) throws Exception {
        ClassParseResult parseResult = ClassEnhancer.parseAndEnhance(pkgs);
        List<String> processesToSubscribe = ARP.getProcessesToSubscribe(parseResult);
        List<String> processesToPublish = ARP.getProcessesToSend(parseResult);
        ProcessPublisher.messageSender = messageSender;
        ProcessPublisher.defineProcessesToPublish(processesToPublish);
        messageConsumer = new ProcessListenerMessageConsumer();
        messageConsumer.start(processesToSubscribe, messageReceiver);
    }

    private static List<String> getProcessesToSend(ClassParseResult parseResult) {
        if (parseResult == null) {
            return null;
        }
        List<ProcessInfo> processInfoList = parseResult.getProcessInfoList();
        ArrayList<String> processesToSend = new ArrayList<String>();
        for (ProcessInfo processInfo : processInfoList) {
            String processDesc = !processInfo.getProcessName().trim().isEmpty() ? processInfo.getProcessName() : processInfo.getClsName() + "." + processInfo.getMthName();
            processesToSend.add(processDesc);
        }
        return processesToSend;
    }

    public static void registerMessageProcessor(String processDesc, ProcessListenerMessageProcessor processor) {
        messageConsumer.registerProcessor(processDesc, processor);
    }

    public static void startJoinMonitor(MonitorMessageConvertor monitorMessageConvertor) throws Exception {
        ClassParseResult parseResult = ClassEnhancer.parseResult;
        List<String> processesToPublish = ARP.getProcessesToSend(parseResult);
        monitorMessageConvertor.start(processesToPublish);
    }
}

