/*
 * Decompiled with CFR 0.152.
 */
package arp.enhance;

import arp.ARP;
import arp.enhance.ClassParseResult;
import arp.enhance.ListenerInfo;
import arp.enhance.ProcessInfo;
import arp.process.Process;
import arp.process.ProcessWrapper;
import arp.process.publish.ProcessListenerMessageProcessor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class ClassEnhancer {
    public static ClassParseResult parseResult;

    public static ClassParseResult parseAndEnhance(String ... pkgs) throws Exception {
        if (pkgs != null) {
            ClassParseResult result = new ClassParseResult();
            HashMap<String, byte[]> enhancedClassBytes = new HashMap<String, byte[]>();
            ArrayList<ProcessInfo> processInfoList = new ArrayList<ProcessInfo>();
            for (int i = 0; i < pkgs.length; ++i) {
                ClassEnhancer.enhanceClassesForPackage(pkgs[i], enhancedClassBytes, processInfoList);
            }
            result.setProcessInfoList(processInfoList);
            if (!processInfoList.isEmpty()) {
                ClassEnhancer.createMessageProcessorClasses(processInfoList);
                ClassEnhancer.enhanceClassesForListners(enhancedClassBytes, processInfoList);
            }
            ClassEnhancer.loadClasses(enhancedClassBytes);
            parseResult = result;
            return result;
        }
        return null;
    }

    private static void createMessageProcessorClasses(List<ProcessInfo> processInfoList) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cls = Class.forName("java.lang.ClassLoader");
        Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        for (ProcessInfo processInfo : processInfoList) {
            ListenerInfo listenerInfo = processInfo.getListenerInfo();
            if (listenerInfo == null) continue;
            Type processOutputType = listenerInfo.getProcessOutputType();
            String listenerProcessObjType = listenerInfo.getListenerProcessObjType();
            String messageProcessorClasseType = listenerProcessObjType.replace('.', '/') + "/MessageProcessor_" + listenerInfo.getListenerMthName();
            ClassWriter cw = new ClassWriter(1);
            cw.visit(52, 1, messageProcessorClasseType, null, Type.getType(Object.class).getInternalName(), new String[]{Type.getType(ProcessListenerMessageProcessor.class).getInternalName()});
            FieldVisitor fv = cw.visitField(2, "processor", "L" + listenerProcessObjType.replace('.', '/') + ";", null, null);
            fv.visitEnd();
            MethodVisitor cmv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType((String)("L" + listenerProcessObjType.replace('.', '/') + ";"))}), null, null);
            cmv.visitMaxs(2, 2);
            cmv.visitCode();
            cmv.visitVarInsn(25, 0);
            cmv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
            cmv.visitVarInsn(25, 0);
            cmv.visitVarInsn(25, 1);
            cmv.visitFieldInsn(181, messageProcessorClasseType, "processor", "L" + listenerProcessObjType.replace('.', '/') + ";");
            cmv.visitInsn(177);
            cmv.visitEnd();
            MethodVisitor mv = cw.visitMethod(1, "process", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), null, null);
            mv.visitMaxs(2, 2);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, messageProcessorClasseType, "processor", "L" + listenerProcessObjType.replace('.', '/') + ";");
            if (processOutputType != null) {
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, processOutputType.getInternalName());
                mv.visitMethodInsn(182, listenerProcessObjType.replace('.', '/'), listenerInfo.getListenerMthName(), listenerInfo.getListenerMthDesc(), false);
            } else {
                mv.visitMethodInsn(182, listenerProcessObjType.replace('.', '/'), listenerInfo.getListenerMthName(), listenerInfo.getListenerMthDesc(), false);
            }
            mv.visitInsn(177);
            mv.visitEnd();
            byte[] enhancedBytes = cw.toByteArray();
            Object[] argArray = new Object[]{messageProcessorClasseType.replace('/', '.'), enhancedBytes, new Integer(0), new Integer(enhancedBytes.length)};
            method.invoke((Object)cl, argArray);
        }
        method.setAccessible(false);
    }

    private static void enhanceClassesForListners(Map<String, byte[]> enhancedClassBytes, List<ProcessInfo> processInfoList) {
        int startIdx = 0;
        int listnersCount = 0;
        String listenerProcessObjType = null;
        for (int i = 0; i < processInfoList.size(); ++i) {
            ProcessInfo processInfo = processInfoList.get(i);
            ListenerInfo listenerInfo = processInfo.getListenerInfo();
            if (listenerInfo == null) continue;
            if (listenerInfo.getListenerProcessObjType().equals(listenerProcessObjType)) {
                ++listnersCount;
                continue;
            }
            ClassEnhancer.enhanceProcessClassWithListners(enhancedClassBytes, listenerProcessObjType, startIdx, listnersCount, processInfoList);
            startIdx = i;
            listnersCount = 1;
            listenerProcessObjType = listenerInfo.getListenerProcessObjType();
        }
        ClassEnhancer.enhanceProcessClassWithListners(enhancedClassBytes, listenerProcessObjType, startIdx, listnersCount, processInfoList);
    }

    private static void enhanceProcessClassWithListners(Map<String, byte[]> enhancedClassBytes, String listenerProcessObjType, final int startIdx, final int listnersCount, final List<ProcessInfo> processInfoList) {
        if (listnersCount == 0) {
            return;
        }
        byte[] bytes = enhancedClassBytes.get(listenerProcessObjType);
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(2);
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
                return new AdviceAdapter(327680, super.visitMethod(access, name, desc, signature, exceptions), access, name, desc){

                    protected void onMethodExit(int opcode) {
                        if (name.equals("<init>")) {
                            for (int i = 0; i < listnersCount; ++i) {
                                ProcessInfo processInfo = (ProcessInfo)processInfoList.get(startIdx + i);
                                ListenerInfo listenerInfo = processInfo.getListenerInfo();
                                if (listenerInfo == null) continue;
                                String processDesc = listenerInfo.getProcessDesc();
                                String listenerProcessObjType = listenerInfo.getListenerProcessObjType();
                                String messageProcessorClasseType = listenerProcessObjType.replace('.', '/') + "/MessageProcessor_" + listenerInfo.getListenerMthName();
                                this.visitLdcInsn(processDesc);
                                this.visitTypeInsn(187, messageProcessorClasseType);
                                this.visitInsn(89);
                                this.visitVarInsn(25, 0);
                                this.visitMethodInsn(183, messageProcessorClasseType, "<init>", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType((String)("L" + listenerProcessObjType.replace('.', '/') + ";"))}), false);
                                this.visitMethodInsn(184, Type.getInternalName(ARP.class), "registerMessageProcessor", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(ProcessListenerMessageProcessor.class)}), false);
                            }
                        }
                        super.onMethodExit(opcode);
                    }
                };
            }
        }, 8);
        byte[] enhancedBytes = cw.toByteArray();
        enhancedClassBytes.put(listenerProcessObjType, enhancedBytes);
    }

    private static void enhanceClassesForPackage(String pkg, final Map<String, byte[]> enhancedClassBytes, final List<ProcessInfo> processInfoList) throws Exception {
        String pkgDir = pkg.replace('.', '/');
        URL url = Thread.currentThread().getContextClassLoader().getResource(pkgDir);
        Path path = Paths.get(new URI(url.toURI().toString()));
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                byte[] bytes = Files.readAllBytes(file);
                ClassEnhancer.enhanceProcess(bytes, enhancedClassBytes, processInfoList);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void loadClasses(Map<String, byte[]> enhancedClassBytes) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cls = Class.forName("java.lang.ClassLoader");
        Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        for (Map.Entry<String, byte[]> entry : enhancedClassBytes.entrySet()) {
            String clsName = entry.getKey();
            byte[] bytes = entry.getValue();
            Object[] argArray = new Object[]{clsName, bytes, new Integer(0), new Integer(bytes.length)};
            method.invoke((Object)cl, argArray);
        }
        method.setAccessible(false);
    }

    private static void enhanceProcess(byte[] bytes, Map<String, byte[]> enhancedClassBytes, final List<ProcessInfo> processInfoList) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(2);
        final HashMap clsInfoMap = new HashMap();
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                clsInfoMap.put("name", name.replace('/', '.'));
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, final String mthName, final String mthDesc, String signature, String[] exceptions) {
                if ("<init>".equals(mthName)) {
                    return super.visitMethod(access, mthName, mthDesc, signature, exceptions);
                }
                final Type[] argumentTypes = Type.getArgumentTypes((String)mthDesc);
                final String returnTypeDesc = mthDesc.substring(mthDesc.indexOf(")") + 1);
                return new AdviceAdapter(327680, super.visitMethod(access, mthName, mthDesc, signature, exceptions), access, mthName, mthDesc){
                    private boolean isProcess;
                    private boolean publish;
                    private boolean dontPublishWhenResultIsNull;
                    private String processName;
                    private Label lTryBlockStart;
                    private Label lTryBlockEnd;
                    {
                        super(x0, x1, x2, x3, x4);
                        this.processName = "";
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        this.isProcess = Type.getDescriptor(Process.class).equals(desc);
                        if (this.isProcess) {
                            clsInfoMap.put("hasProcess", true);
                            return new AnnotationVisitor(327680, super.visitAnnotation(desc, visible)){

                                public void visit(String name, Object value) {
                                    ListenerInfo listenerInfo = null;
                                    if ("publish".equals(name) && Boolean.TRUE.equals(value)) {
                                        publish = true;
                                    } else if ("dontPublishWhenResultIsNull".equals(name) && Boolean.TRUE.equals(value)) {
                                        dontPublishWhenResultIsNull = true;
                                    } else if ("name".equals(name)) {
                                        processName = (String)value;
                                    } else if ("listening".equals(name)) {
                                        Type processOutputType = null;
                                        if (argumentTypes != null && argumentTypes.length > 0) {
                                            processOutputType = argumentTypes[0];
                                        }
                                        listenerInfo = new ListenerInfo((String)value, processOutputType, (String)clsInfoMap.get("name"), mthName, mthDesc);
                                    }
                                    processInfoList.add(new ProcessInfo((String)clsInfoMap.get("name"), mthName, processName, listenerInfo, publish));
                                    super.visit(name, value);
                                }
                            };
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    protected void onMethodEnter() {
                        if (this.isProcess) {
                            if (this.publish) {
                                this.visitInsn(4);
                            } else {
                                this.visitInsn(3);
                            }
                            this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "setPublish", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Boolean.TYPE)}), false);
                            if (this.publish) {
                                this.visitLdcInsn(clsInfoMap.get("name"));
                                this.visitLdcInsn(mthName);
                                this.visitLdcInsn(this.processName);
                                this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "recordProcessDesc", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(String.class), Type.getType(String.class)}), false);
                                if (this.dontPublishWhenResultIsNull) {
                                    this.visitInsn(4);
                                } else {
                                    this.visitInsn(3);
                                }
                                this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "setDontPublishWhenResultIsNull", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Boolean.TYPE)}), false);
                                if (argumentTypes != null) {
                                    int localNum = 1;
                                    for (int argIdx = 0; argIdx < argumentTypes.length; ++argIdx) {
                                        Type argType = argumentTypes[argIdx];
                                        localNum = ClassEnhancer.loadLocalAndToObject(localNum, argType.getDescriptor(), this);
                                        this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "recordProcessArgument", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class)}), false);
                                    }
                                }
                            }
                            this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "beforeProcessStart", "()V", false);
                            this.lTryBlockStart = new Label();
                            this.lTryBlockEnd = new Label();
                            this.mark(this.lTryBlockStart);
                        }
                        super.onMethodEnter();
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        if (this.isProcess) {
                            this.mark(this.lTryBlockEnd);
                            this.catchException(this.lTryBlockStart, this.lTryBlockEnd, null);
                            this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "afterProcessFaild", "()V", false);
                            this.throwException();
                        }
                        super.visitMaxs(maxStack, maxLocals);
                    }

                    protected void onMethodExit(int opcode) {
                        if (this.isProcess) {
                            if (this.publish && !Type.getDescriptor(Void.TYPE).equals(returnTypeDesc)) {
                                ClassEnhancer.dupStackTopAndToObject(returnTypeDesc, this);
                                this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "recordProcessResult", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class)}), false);
                            }
                            this.visitMethodInsn(184, Type.getInternalName(ProcessWrapper.class), "afterProcessFinish", "()V", false);
                        }
                        super.onMethodExit(opcode);
                    }
                };
            }
        }, 8);
        if (Boolean.TRUE.equals(clsInfoMap.get("hasProcess"))) {
            byte[] enhancedBytes = cw.toByteArray();
            enhancedClassBytes.put((String)clsInfoMap.get("name"), enhancedBytes);
        }
    }

    private static void dupStackTopAndToObject(String stackTopTypeDesc, AdviceAdapter adviceAdapter) {
        ClassEnhancer.dupStackTop(stackTopTypeDesc, adviceAdapter);
        ClassEnhancer.stackTopToObject(stackTopTypeDesc, adviceAdapter);
    }

    private static int loadLocalAndToObject(int localNum, String localTypeDesc, AdviceAdapter adviceAdapter) {
        int newLocalNum = ClassEnhancer.loadLocal(localNum, localTypeDesc, adviceAdapter);
        ClassEnhancer.stackTopToObject(localTypeDesc, adviceAdapter);
        return newLocalNum;
    }

    private static int loadLocal(int localNum, String localTypeDesc, AdviceAdapter adviceAdapter) {
        if (Type.getDescriptor(Byte.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(21, localNum);
            return localNum + 1;
        }
        if (Type.getDescriptor(Character.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(21, localNum);
            return localNum + 1;
        }
        if (Type.getDescriptor(Short.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(21, localNum);
            return localNum + 1;
        }
        if (Type.getDescriptor(Float.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(23, localNum);
            return localNum + 1;
        }
        if (Type.getDescriptor(Integer.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(21, localNum);
            return localNum + 1;
        }
        if (Type.getDescriptor(Double.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(24, localNum);
            return localNum + 2;
        }
        if (Type.getDescriptor(Long.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(22, localNum);
            return localNum + 2;
        }
        if (Type.getDescriptor(Boolean.TYPE).equals(localTypeDesc)) {
            adviceAdapter.visitVarInsn(21, localNum);
            return localNum + 1;
        }
        adviceAdapter.visitVarInsn(25, localNum);
        return localNum + 1;
    }

    private static void stackTopToObject(String stackTopTypeDesc, AdviceAdapter adviceAdapter) {
        if (Type.getDescriptor(Byte.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Byte.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Byte.class), (Type[])new Type[]{Type.getType(Byte.TYPE)}), false);
        } else if (Type.getDescriptor(Character.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Character.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Character.class), (Type[])new Type[]{Type.getType(Character.TYPE)}), false);
        } else if (Type.getDescriptor(Short.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Short.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Short.class), (Type[])new Type[]{Type.getType(Short.TYPE)}), false);
        } else if (Type.getDescriptor(Float.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Float.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Float.class), (Type[])new Type[]{Type.getType(Float.TYPE)}), false);
        } else if (Type.getDescriptor(Integer.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.getType(Integer.TYPE)}), false);
        } else if (Type.getDescriptor(Double.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Double.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Double.class), (Type[])new Type[]{Type.getType(Double.TYPE)}), false);
        } else if (Type.getDescriptor(Long.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.getType(Long.TYPE)}), false);
        } else if (Type.getDescriptor(Boolean.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitMethodInsn(184, Type.getInternalName(Boolean.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Boolean.class), (Type[])new Type[]{Type.getType(Boolean.TYPE)}), false);
        }
    }

    private static void dupStackTop(String stackTopTypeDesc, AdviceAdapter adviceAdapter) {
        if (Type.getDescriptor(Long.TYPE).equals(stackTopTypeDesc) || Type.getDescriptor(Double.TYPE).equals(stackTopTypeDesc)) {
            adviceAdapter.visitInsn(92);
        } else {
            adviceAdapter.visitInsn(89);
        }
    }
}

