/*
 * Decompiled with CFR 0.152.
 */
package arp.process;

import arp.process.CreatedProcessEntityState;
import arp.process.ProcessEntity;
import arp.process.RemovedProcessEntityState;
import arp.process.TakenProcessEntityState;
import arp.process.TransientProcessEntityState;
import arp.repository.Repository;
import arp.repository.RepositoryProcessEntities;
import arp.util.Unsafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessContext {
    private boolean started;
    private Map<Integer, RepositoryProcessEntities<?, ?>> processEntities = new HashMap();
    private List<AtomicInteger> singleEntityAcquiredLocks = new ArrayList<AtomicInteger>();
    private List<Object> arguments = new ArrayList<Object>();
    private Object result;
    private List<Object> createdAggrs = new ArrayList<Object>();
    private List<Object> deletedAggrs = new ArrayList<Object>();
    private List<Object[]> updatedAggrs = new ArrayList<Object[]>();
    private boolean dontPublishWhenResultIsNull;
    private String processDesc;
    private boolean publish;

    public void startProcess() {
        if (this.started) {
            throw new RuntimeException("can not start a process in another started process");
        }
        this.started = true;
        Unsafe.loadFence();
    }

    public void finishProcess() {
        Unsafe.storeFence();
        try {
            this.flushProcessEntities();
        }
        catch (Exception e) {
            try {
                this.releaseAcquiredLocks();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clear();
            this.started = false;
            throw new RuntimeException("flush process entities faild", e);
        }
        try {
            this.releaseAcquiredLocks();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.started = false;
    }

    private void flushProcessEntities() throws Exception {
        for (RepositoryProcessEntities<?, ?> entities : this.processEntities.values()) {
            Repository repository = Repository.getRepository(entities.getRepositoryId());
            Map<?, ProcessEntity<?>> processEntities = entities.getEntities();
            HashMap entitiesToCreate = new HashMap();
            HashMap entitiesToUpdate = new HashMap();
            HashSet idsToRemove = new HashSet();
            Iterator<Map.Entry<?, ProcessEntity<?>>> iterator = processEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ProcessEntity<?>> obj;
                Map.Entry<?, ProcessEntity<?>> entry = obj = iterator.next();
                Object id = entry.getKey();
                ProcessEntity<?> processEntity = entry.getValue();
                if (processEntity.getState() instanceof CreatedProcessEntityState) {
                    entitiesToCreate.put(id, processEntity.getEntity());
                    this.createdAggrs.add(processEntity.getEntity());
                    continue;
                }
                if (processEntity.getState() instanceof TakenProcessEntityState) {
                    if (!processEntity.changed()) continue;
                    entitiesToUpdate.put(id, processEntity.getEntity());
                    this.updatedAggrs.add(new Object[]{processEntity.getInitialEntitySnapshot(), processEntity.getEntity()});
                    continue;
                }
                if (!(processEntity.getState() instanceof RemovedProcessEntityState)) continue;
                idsToRemove.add(id);
                this.deletedAggrs.add(processEntity.getEntity());
            }
            if (!idsToRemove.isEmpty()) {
                repository.deleteEntities(idsToRemove);
            }
            if (!entitiesToUpdate.isEmpty()) {
                repository.updateEntities(entitiesToUpdate);
            }
            if (entitiesToCreate.isEmpty()) continue;
            repository.createEntities(entitiesToCreate);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public <I, E> ProcessEntity<E> getEntityInProcessForTake(int repositoryId, I entityId) {
        RepositoryProcessEntities<?, ?> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            return null;
        }
        return entities.takeEntity(entityId);
    }

    public <I, E> E copyEntityInProcess(int repositoryId, I entityId) {
        RepositoryProcessEntities<?, ?> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            return null;
        }
        return (E)entities.copyEntity(entityId);
    }

    public <I, E> void takeEntityFromRepoAndPutInProcess(int repositoryId, I entityId, E entity) {
        RepositoryProcessEntities<Object, Object> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            entities = new RepositoryProcessEntities(repositoryId);
            this.processEntities.put(repositoryId, entities);
        }
        entities.takeEntityFromRepoAndPutInProcess(entityId, entity);
    }

    public <I, E> void takeEntityFromRepoAndPutInProcessAsRemoved(int repositoryId, I entityId, E entity) {
        RepositoryProcessEntities<Object, Object> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            entities = new RepositoryProcessEntities(repositoryId);
            this.processEntities.put(repositoryId, entities);
        }
        entities.takeEntityFromRepoAndPutInProcessAsRemoved(entityId, entity);
    }

    public <I, E> void putEntityInProcess(int repositoryId, I entityId, E entity) {
        RepositoryProcessEntities<Object, Object> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            entities = new RepositoryProcessEntities(repositoryId);
            this.processEntities.put(repositoryId, entities);
        }
        entities.putEntityInProcess(entityId, entity);
    }

    public <I, E> ProcessEntity<E> putIfAbsentEntityInProcess(int repositoryId, I entityId, E entity) {
        RepositoryProcessEntities<?, ?> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            return null;
        }
        ProcessEntity<?> processEntity = entities.findEntity(entityId);
        if (processEntity == null) {
            return null;
        }
        if (processEntity.getState() instanceof RemovedProcessEntityState) {
            processEntity.setEntity(entity);
            processEntity.updateStateByPut();
            return processEntity;
        }
        if (processEntity.getState() instanceof TransientProcessEntityState) {
            return null;
        }
        return processEntity;
    }

    public <I, E> ProcessEntity<E> removeEntityInProcess(int repositoryId, I entityId) {
        RepositoryProcessEntities<?, ?> entities = this.processEntities.get(repositoryId);
        if (entities == null) {
            return null;
        }
        ProcessEntity<?> processEntity = entities.findEntity(entityId);
        if (processEntity == null) {
            return null;
        }
        if (processEntity.getState() instanceof TransientProcessEntityState) {
            return null;
        }
        processEntity.updateStateByRemove();
        return processEntity;
    }

    public void processFaild() {
        try {
            this.releaseAcquiredLocks();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear();
        this.started = false;
    }

    public void clear() {
        this.processEntities.clear();
        this.arguments.clear();
        this.createdAggrs.clear();
        this.deletedAggrs.clear();
        this.updatedAggrs.clear();
        this.result = null;
        this.dontPublishWhenResultIsNull = false;
        this.processDesc = null;
        this.publish = false;
    }

    private void releaseAcquiredLocks() throws Exception {
        for (RepositoryProcessEntities<?, ?> entities : this.processEntities.values()) {
            Repository repository = Repository.getRepository(entities.getRepositoryId());
            Map<?, ProcessEntity<?>> processEntities = entities.getEntities();
            HashSet idsToUnlock = new HashSet();
            Iterator<Map.Entry<?, ProcessEntity<?>>> iterator = processEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<?, ProcessEntity<?>> obj;
                Map.Entry<?, ProcessEntity<?>> entry = obj = iterator.next();
                Object id = entry.getKey();
                ProcessEntity<?> processEntity = entry.getValue();
                if (processEntity.getState() instanceof TakenProcessEntityState) {
                    idsToUnlock.add(id);
                    continue;
                }
                if (!(processEntity.getState() instanceof RemovedProcessEntityState)) continue;
                idsToUnlock.add(id);
            }
            repository.returnEntities(idsToUnlock);
        }
        for (AtomicInteger lock : this.singleEntityAcquiredLocks) {
            lock.set(0);
        }
    }

    public void addSingleEntityAcquiredLock(AtomicInteger lock) {
        this.singleEntityAcquiredLocks.add(lock);
    }

    public void recordProcessResult(Object result) {
        this.result = result;
    }

    public void setDontPublishWhenResultIsNull(boolean dontPublishWhenResultIsNull) {
        this.dontPublishWhenResultIsNull = dontPublishWhenResultIsNull;
    }

    public void recordProcessDesc(String clsName, String mthName, String processName) {
        this.processDesc = !processName.trim().isEmpty() ? processName : clsName + "." + mthName;
    }

    public void addCreatedAggr(Object createdAggr) {
        this.createdAggrs.add(createdAggr);
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isDontPublishWhenResultIsNull() {
        return this.dontPublishWhenResultIsNull;
    }

    public String getProcessDesc() {
        return this.processDesc;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public void recordProcessArgument(Object argument) {
        this.arguments.add(argument);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<Object[]> getUpdatedAggrs() {
        return this.updatedAggrs;
    }

    public List<Object> getCreatedAggrs() {
        return this.createdAggrs;
    }

    public List<Object> getDeletedAggrs() {
        return this.deletedAggrs;
    }
}

