/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.repository.MemRepository;
import arp.util.Unsafe;
import java.lang.reflect.Field;

public class CommonMemRepository<E>
extends MemRepository<E, Object> {
    private Class<?> idFieldType;
    private long idFieldOffset;

    public CommonMemRepository(Class<E> cls) {
        try {
            Field idField = cls.getDeclaredField("id");
            this.idFieldType = idField.getType();
            this.idFieldOffset = Unsafe.getFieldOffset(idField);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Object getId(E entity) {
        try {
            if (Byte.TYPE.equals(this.idFieldType)) {
                return Unsafe.getByteFieldOfObject(entity, this.idFieldOffset);
            }
            if (Short.TYPE.equals(this.idFieldType)) {
                return Unsafe.getShortFieldOfObject(entity, this.idFieldOffset);
            }
            if (Character.TYPE.equals(this.idFieldType)) {
                return Character.valueOf(Unsafe.getCharFieldOfObject(entity, this.idFieldOffset));
            }
            if (Integer.TYPE.equals(this.idFieldType)) {
                return Unsafe.getIntFieldOfObject(entity, this.idFieldOffset);
            }
            if (Float.TYPE.equals(this.idFieldType)) {
                return Float.valueOf(Unsafe.getFloatFieldOfObject(entity, this.idFieldOffset));
            }
            if (Long.TYPE.equals(this.idFieldType)) {
                return Unsafe.getLongFieldOfObject(entity, this.idFieldOffset);
            }
            if (Double.TYPE.equals(this.idFieldType)) {
                return Unsafe.getDoubleFieldOfObject(entity, this.idFieldOffset);
            }
            if (Boolean.TYPE.equals(this.idFieldType)) {
                return Unsafe.getBooleanFieldOfObject(entity, this.idFieldOffset);
            }
            return Unsafe.getObjectFieldOfObject(entity, this.idFieldOffset);
        }
        catch (Exception e) {
            return null;
        }
    }
}

