/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.repository.CanNotAcquireLockException;
import arp.repository.Repository;
import arp.repository.copy.EntityCopier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public abstract class MemRepository<E, I>
extends Repository<E, I> {
    private Map<I, E> data = new ConcurrentHashMap<I, E>();
    private Map<I, AtomicInteger> locks = new ConcurrentHashMap<I, AtomicInteger>();

    private void unlock(I id) {
        AtomicInteger lock = this.locks.get(id);
        if (lock != null) {
            lock.set(0);
        }
    }

    private void acquireLock(I id) {
        AtomicInteger newLock;
        AtomicInteger lock = this.locks.get(id);
        if (lock == null && (lock = this.locks.putIfAbsent(id, newLock = new AtomicInteger())) == null) {
            lock = newLock;
        }
        int tid = (int)Thread.currentThread().getId();
        if (lock.get() == tid) {
            return;
        }
        int counter = 300;
        while (true) {
            if (lock.compareAndSet(0, tid)) {
                return;
            }
            if (counter > 200) {
                --counter;
                continue;
            }
            if (counter > 100) {
                --counter;
                Thread.yield();
                continue;
            }
            if (counter <= 0) break;
            --counter;
            LockSupport.parkNanos(1L);
        }
        throw new CanNotAcquireLockException();
    }

    @Override
    protected E findByIdForUpdateFromStore(I id) {
        if (this.data.get(id) == null) {
            return null;
        }
        this.acquireLock(id);
        return this.data.get(id);
    }

    @Override
    protected E findByIdFromStore(I id) {
        return EntityCopier.copy(this.data.get(id));
    }

    @Override
    protected E saveIfAbsentToStore(I id, E entity) {
        this.acquireLock(id);
        E existsEntity = this.data.putIfAbsent(id, entity);
        return existsEntity;
    }

    @Override
    protected void removeAllToStore(Set<I> ids) {
        for (I id : ids) {
            this.data.remove(id);
            this.locks.remove(id);
        }
    }

    @Override
    protected void updateAllToStore(Map<I, E> entities) {
        for (Map.Entry<I, E> entry : entities.entrySet()) {
            I id = entry.getKey();
            this.data.put(id, EntityCopier.copy(entry.getValue()));
            this.unlock(id);
        }
    }

    @Override
    protected void saveAllToStore(Map<I, E> entities) {
        for (Map.Entry<I, E> entry : entities.entrySet()) {
            this.data.put(entry.getKey(), EntityCopier.copy(entry.getValue()));
        }
    }

    @Override
    protected void unlockAllToStore(Set<I> ids) {
        for (I id : ids) {
            this.unlock(id);
        }
    }

    public Set<I> idSet() {
        return new HashSet<I>(this.data.keySet());
    }
}

