/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.repository.Repository;
import java.util.Map;
import java.util.Set;

public abstract class PersistenceRepository<E, I>
extends Repository<E, I> {
    @Override
    protected E findByIdForUpdateFromStore(I id) {
        E entity = this.findByIdForUpdateImpl(id);
        return entity;
    }

    protected abstract E findByIdForUpdateImpl(I var1);

    @Override
    protected E findByIdFromStore(I id) {
        return this.findByIdImpl(id);
    }

    protected abstract E findByIdImpl(I var1);

    @Override
    protected E saveIfAbsentToStore(I id, E entity) {
        entity = this.saveIfAbsentImpl(id, entity);
        return entity;
    }

    protected abstract E saveIfAbsentImpl(I var1, E var2);

    @Override
    protected void removeAllToStore(Set<I> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (ids.size() == 1) {
            this.removeImpl(ids.iterator().next());
        } else {
            this.removeBatchImpl(ids);
        }
    }

    @Override
    protected void updateAllToStore(Map<I, E> entities) {
        I oneId = null;
        E oneEntity = null;
        for (Map.Entry<I, E> entry : entities.entrySet()) {
            I id = entry.getKey();
            oneId = id;
            E entity = entry.getValue();
            oneEntity = entity;
        }
        if (entities.isEmpty()) {
            return;
        }
        if (entities.size() == 1) {
            this.updateImpl(oneId, oneEntity);
        } else {
            this.updateBatchImpl(entities);
        }
    }

    protected abstract void updateBatchImpl(Map<I, E> var1);

    protected abstract void updateImpl(I var1, E var2);

    @Override
    protected void saveAllToStore(Map<I, E> entities) {
        if (entities.isEmpty()) {
            return;
        }
        if (entities.size() == 1) {
            I oneId = null;
            E oneEntity = null;
            for (I id : entities.keySet()) {
                oneId = id;
                oneEntity = entities.get(id);
            }
            this.saveImpl(oneId, oneEntity);
        } else {
            this.saveBatchImpl(entities);
        }
    }

    @Override
    protected void unlockAllToStore(Set<I> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (ids.size() == 1) {
            this.unlockImpl(ids.iterator().next());
        } else {
            this.unlockBatchImpl(ids);
        }
    }

    protected abstract void saveBatchImpl(Map<I, E> var1);

    protected abstract void saveImpl(I var1, E var2);

    protected abstract void removeBatchImpl(Set<I> var1);

    protected abstract void removeImpl(I var1);

    protected abstract void unlockBatchImpl(Set<I> var1);

    protected abstract void unlockImpl(I var1);
}

