/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.process.CreatedProcessEntityState;
import arp.process.ProcessContext;
import arp.process.ProcessEntity;
import arp.process.ProcessEntityState;
import arp.process.TakenProcessEntityState;
import arp.process.ThreadBoundProcessContextArray;
import arp.process.TransientProcessEntityState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Repository<E, I> {
    private static AtomicInteger ids = new AtomicInteger();
    private static Repository[] repositories = new Repository[1024];
    private int id = ids.incrementAndGet();
    private Map<I, E> mockStore;
    private boolean mock = false;

    public static Repository getRepository(int id) {
        return repositories[id];
    }

    protected Repository() {
        Repository.repositories[this.id] = this;
    }

    protected void initAsMock() {
        this.mock = true;
        this.mockStore = new HashMap<I, E>();
    }

    protected abstract I getId(E var1);

    public E findByIdForUpdate(I id) {
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        ProcessEntity processEntity = processContext.getEntityInProcessForTake(this.id, id);
        if (processEntity != null) {
            ProcessEntityState entityState = processEntity.getState();
            if (entityState instanceof CreatedProcessEntityState || entityState instanceof TakenProcessEntityState) {
                return processEntity.getEntity();
            }
            return null;
        }
        E entity = this.doFindByIdForUpdate(id);
        if (entity != null) {
            processContext.takeEntityFromRepoAndPutInProcess(this.id, id, entity);
        }
        return entity;
    }

    private E doFindByIdForUpdate(I id) {
        if (!this.mock) {
            return this.findByIdForUpdateFromStore(id);
        }
        return this.mockStore.get(id);
    }

    protected abstract E findByIdForUpdateFromStore(I var1);

    public E findById(I id) {
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        Object entity = processContext.copyEntityInProcess(this.id, id);
        if (entity != null) {
            return entity;
        }
        return this.doFindById(id);
    }

    private E doFindById(I id) {
        if (!this.mock) {
            return this.findByIdFromStore(id);
        }
        return this.mockStore.get(id);
    }

    protected abstract E findByIdFromStore(I var1);

    public void save(E entity) {
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        I id = this.getId(entity);
        processContext.putEntityInProcess(this.id, id, entity);
    }

    public E saveIfAbsent(E entity) {
        ProcessEntityState entityState;
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        I id = this.getId(entity);
        ProcessEntity<E> processEntity = processContext.putIfAbsentEntityInProcess(this.id, id, entity);
        if (processEntity != null && !((entityState = processEntity.getState()) instanceof TransientProcessEntityState)) {
            return processEntity.getEntity();
        }
        E entityFromStore = this.doSaveIfAbsent(id, entity);
        if (entityFromStore != null) {
            processContext.takeEntityFromRepoAndPutInProcess(this.id, id, entityFromStore);
        } else {
            processContext.addCreatedAggr(entity);
            processContext.takeEntityFromRepoAndPutInProcess(this.id, id, entity);
        }
        return entityFromStore;
    }

    private E doSaveIfAbsent(I id, E entity) {
        if (!this.mock) {
            return this.saveIfAbsentToStore(id, entity);
        }
        return this.mockStore.putIfAbsent(id, entity);
    }

    protected abstract E saveIfAbsentToStore(I var1, E var2);

    public E remove(I id) {
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        ProcessEntity processEntity = processContext.removeEntityInProcess(this.id, id);
        if (processEntity != null) {
            return processEntity.getEntity();
        }
        E entityFromStore = this.doFindByIdForUpdate(id);
        if (entityFromStore != null) {
            processContext.takeEntityFromRepoAndPutInProcessAsRemoved(this.id, id, entityFromStore);
        }
        return entityFromStore;
    }

    public void deleteEntities(Set<I> ids) {
        if (!this.mock) {
            this.removeAllToStore(ids);
        } else {
            for (I id : ids) {
                this.mockStore.remove(id);
            }
        }
    }

    protected abstract void removeAllToStore(Set<I> var1);

    public void updateEntities(Map<I, E> entitiesToReturn) {
        if (!this.mock) {
            this.updateAllToStore(entitiesToReturn);
        }
    }

    protected abstract void updateAllToStore(Map<I, E> var1);

    public void createEntities(Map<I, E> entitiesToCreate) {
        if (!this.mock) {
            this.saveAllToStore(entitiesToCreate);
        } else {
            this.mockStore.putAll(entitiesToCreate);
        }
    }

    protected abstract void saveAllToStore(Map<I, E> var1);

    public void returnEntities(Set<I> ids) {
        if (!this.mock) {
            this.unlockAllToStore(ids);
        }
    }

    protected abstract void unlockAllToStore(Set<I> var1);
}

