/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.process.CreatedProcessEntityState;
import arp.process.ProcessEntity;
import arp.process.RemovedProcessEntityState;
import arp.process.TakenProcessEntityState;
import arp.repository.copy.EntityCopier;
import java.util.HashMap;
import java.util.Map;

public class RepositoryProcessEntities<I, E> {
    private int repositoryId;
    private Map<I, ProcessEntity<E>> entities = new HashMap<I, ProcessEntity<E>>();

    public RepositoryProcessEntities(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void takeEntityFromRepoAndPutInProcess(I entityId, E entity) {
        ProcessEntity<E> processEntity = new ProcessEntity<E>();
        processEntity.setInitialEntitySnapshot(EntityCopier.copy(entity));
        processEntity.setEntity(entity);
        processEntity.setState(new TakenProcessEntityState());
        this.entities.put(entityId, processEntity);
    }

    public void takeEntityFromRepoAndPutInProcessAsRemoved(I entityId, E entity) {
        ProcessEntity<E> processEntity = new ProcessEntity<E>();
        processEntity.setInitialEntitySnapshot(EntityCopier.copy(entity));
        processEntity.setEntity(entity);
        processEntity.setState(new RemovedProcessEntityState());
        this.entities.put(entityId, processEntity);
    }

    public ProcessEntity<E> takeEntity(I entityId) {
        ProcessEntity<E> processEntity = this.entities.get(entityId);
        if (processEntity == null) {
            return null;
        }
        processEntity.updateStateByTake();
        return processEntity;
    }

    public E copyEntity(I entityId) {
        ProcessEntity<E> processEntity = this.entities.get(entityId);
        if (processEntity == null) {
            return null;
        }
        return EntityCopier.copy(processEntity.getEntity());
    }

    public ProcessEntity<E> findEntity(I entityId) {
        return this.entities.get(entityId);
    }

    public void putEntityInProcess(I entityId, E entity) {
        ProcessEntity<Object> processEntity = this.entities.get(entityId);
        if (processEntity == null) {
            processEntity = new ProcessEntity();
            processEntity.setEntity(entity);
            processEntity.setState(new CreatedProcessEntityState());
            this.entities.put(entityId, processEntity);
        } else {
            processEntity.updateStateByPut();
        }
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public Map<I, ProcessEntity<E>> getEntities() {
        return this.entities;
    }
}

