/*
 * Decompiled with CFR 0.152.
 */
package arp.repository;

import arp.process.ProcessContext;
import arp.process.ThreadBoundProcessContextArray;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public abstract class SingleEntityRepository<T> {
    private AtomicInteger lock = new AtomicInteger();
    private T entity;

    public T getForUpdate() {
        ProcessContext processContext = ThreadBoundProcessContextArray.getProcessContext();
        if (!processContext.isStarted()) {
            throw new RuntimeException("can not use repository without a process");
        }
        this.acquireLock(processContext);
        return this.entity;
    }

    public T get() {
        return this.entity;
    }

    public void put(T entity) {
        this.entity = entity;
    }

    private void acquireLock(ProcessContext processContext) {
        int counter = 200;
        while (true) {
            if (this.lock.compareAndSet(0, 1)) {
                processContext.addSingleEntityAcquiredLock(this.lock);
                return;
            }
            if (counter > 100) {
                --counter;
                continue;
            }
            if (counter > 0) {
                --counter;
                Thread.yield();
                continue;
            }
            LockSupport.parkNanos(1L);
        }
    }
}

