/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.compare;

import arp.repository.compare.BooleanFieldComparator;
import arp.repository.compare.ByteFieldComparator;
import arp.repository.compare.CharFieldComparator;
import arp.repository.compare.DoubleFieldComparator;
import arp.repository.compare.EntityFieldComparator;
import arp.repository.compare.FieldComparator;
import arp.repository.compare.FloatFieldComparator;
import arp.repository.compare.IntFieldComparator;
import arp.repository.compare.JavaObjectFieldComparator;
import arp.repository.compare.LongFieldComparator;
import arp.repository.compare.ShortFieldComparator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityComparator {
    private static Map<String, FieldComparator[]> typeFieldComparators = new ConcurrentHashMap<String, FieldComparator[]>();

    public static <T> boolean equals(T one, T another) {
        if (one == null && another == null) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        String clsName = one.getClass().getName();
        FieldComparator[] fieldComparators = typeFieldComparators.get(clsName);
        if (fieldComparators == null) {
            fieldComparators = EntityComparator.buildFieldComparators(one.getClass());
            typeFieldComparators.putIfAbsent(clsName, fieldComparators);
        }
        for (FieldComparator fieldComparator : fieldComparators) {
            if (fieldComparator.equals(one, another)) continue;
            return false;
        }
        return true;
    }

    private static FieldComparator[] buildFieldComparators(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        FieldComparator[] comparators = new FieldComparator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Class<?> fieldType = field.getType();
            comparators[i] = Byte.TYPE.equals(fieldType) ? new ByteFieldComparator(field) : (Short.TYPE.equals(fieldType) ? new ShortFieldComparator(field) : (Character.TYPE.equals(fieldType) ? new CharFieldComparator(field) : (Integer.TYPE.equals(fieldType) ? new IntFieldComparator(field) : (Long.TYPE.equals(fieldType) ? new LongFieldComparator(field) : (Float.TYPE.equals(fieldType) ? new FloatFieldComparator(field) : (Double.TYPE.equals(fieldType) ? new DoubleFieldComparator(field) : (Boolean.TYPE.equals(fieldType) ? new BooleanFieldComparator(field) : (Byte.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Short.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Character.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Integer.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Long.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Float.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Double.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Boolean.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (String.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Enum.class.equals(fieldType.getSuperclass()) ? new JavaObjectFieldComparator(field) : (fieldType.getName().startsWith("[") ? new JavaObjectFieldComparator(field) : (ArrayList.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (LinkedList.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (List.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Queue.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (HashSet.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Set.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (HashMap.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : (Map.class.equals(fieldType) ? new JavaObjectFieldComparator(field) : new EntityFieldComparator(field)))))))))))))))))))))))))));
        }
        return comparators;
    }
}

