/*
 * Decompiled with CFR 0.152.
 */
package arp.repository.copy;

import arp.repository.copy.ArrayListFieldCopier;
import arp.repository.copy.BooleanArrayFieldCopier;
import arp.repository.copy.BooleanFieldCopier;
import arp.repository.copy.ByteArrayFieldCopier;
import arp.repository.copy.ByteFieldCopier;
import arp.repository.copy.CharArrayFieldCopier;
import arp.repository.copy.CharFieldCopier;
import arp.repository.copy.DoubleArrayFieldCopier;
import arp.repository.copy.DoubleFieldCopier;
import arp.repository.copy.EntityFieldCopier;
import arp.repository.copy.FieldCopier;
import arp.repository.copy.FloatArrayFieldCopier;
import arp.repository.copy.FloatFieldCopier;
import arp.repository.copy.HashMapFieldCopier;
import arp.repository.copy.HashSetFieldCopier;
import arp.repository.copy.IntArrayFieldCopier;
import arp.repository.copy.IntFieldCopier;
import arp.repository.copy.LinkedListFieldCopier;
import arp.repository.copy.ListFieldCopier;
import arp.repository.copy.LongArrayFieldCopier;
import arp.repository.copy.LongFieldCopier;
import arp.repository.copy.MapFieldCopier;
import arp.repository.copy.QueueFieldCopier;
import arp.repository.copy.SetFieldCopier;
import arp.repository.copy.ShortArrayFieldCopier;
import arp.repository.copy.ShortFieldCopier;
import arp.repository.copy.ValueObjectArrayFieldCopier;
import arp.repository.copy.ValueObjectFieldCopier;
import arp.util.Unsafe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityCopier {
    private static Map<String, FieldCopier[]> typeFieldCopiers = new ConcurrentHashMap<String, FieldCopier[]>();

    public static <T> T copy(T entity) {
        if (entity == null) {
            return null;
        }
        if (Enum.class.equals(entity.getClass().getSuperclass())) {
            return entity;
        }
        Object copyOfEntity = Unsafe.allocateInstance(entity.getClass());
        String clsName = entity.getClass().getName();
        FieldCopier[] fieldCopiers = typeFieldCopiers.get(clsName);
        if (fieldCopiers == null) {
            fieldCopiers = EntityCopier.buildFieldCopiers(entity.getClass());
            typeFieldCopiers.putIfAbsent(clsName, fieldCopiers);
        }
        for (FieldCopier fieldCopier : fieldCopiers) {
            fieldCopier.copyField(entity, copyOfEntity);
        }
        return copyOfEntity;
    }

    private static FieldCopier[] buildFieldCopiers(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        FieldCopier[] copiers = new FieldCopier[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Class<?> fieldType = field.getType();
            copiers[i] = Byte.TYPE.equals(fieldType) ? new ByteFieldCopier(field) : (Short.TYPE.equals(fieldType) ? new ShortFieldCopier(field) : (Character.TYPE.equals(fieldType) ? new CharFieldCopier(field) : (Integer.TYPE.equals(fieldType) ? new IntFieldCopier(field) : (Long.TYPE.equals(fieldType) ? new LongFieldCopier(field) : (Float.TYPE.equals(fieldType) ? new FloatFieldCopier(field) : (Double.TYPE.equals(fieldType) ? new DoubleFieldCopier(field) : (Boolean.TYPE.equals(fieldType) ? new BooleanFieldCopier(field) : (Byte.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Short.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Character.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Integer.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Long.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Float.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Double.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Boolean.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (String.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (Enum.class.equals(fieldType.getSuperclass()) ? new ValueObjectFieldCopier(field) : (Object.class.equals(fieldType) ? new ValueObjectFieldCopier(field) : (byte[].class.equals(fieldType) ? new ByteArrayFieldCopier(field) : (short[].class.equals(fieldType) ? new ShortArrayFieldCopier(field) : (char[].class.equals(fieldType) ? new CharArrayFieldCopier(field) : (int[].class.equals(fieldType) ? new IntArrayFieldCopier(field) : (long[].class.equals(fieldType) ? new LongArrayFieldCopier(field) : (float[].class.equals(fieldType) ? new FloatArrayFieldCopier(field) : (double[].class.equals(fieldType) ? new DoubleArrayFieldCopier(field) : (boolean[].class.equals(fieldType) ? new BooleanArrayFieldCopier(field) : (fieldType.getName().startsWith("[L") ? new ValueObjectArrayFieldCopier(field) : (ArrayList.class.equals(fieldType) ? new ArrayListFieldCopier(field) : (LinkedList.class.equals(fieldType) ? new LinkedListFieldCopier(field) : (List.class.equals(fieldType) ? new ListFieldCopier(field) : (Queue.class.equals(fieldType) ? new QueueFieldCopier(field) : (HashSet.class.equals(fieldType) ? new HashSetFieldCopier(field) : (Set.class.equals(fieldType) ? new SetFieldCopier(field) : (HashMap.class.equals(fieldType) ? new HashMapFieldCopier(field) : (Map.class.equals(fieldType) ? new MapFieldCopier(field) : new EntityFieldCopier(field))))))))))))))))))))))))))))))))))));
        }
        return copiers;
    }
}

