package arp.repository;

import arp.process.publish.ProcessMessageReceiver;

public class ViewCachedRepositorySynchronizer {

	private static ViewCacheUpdateMessageConsumer viewCacheUpdateMessageConsumer;

	public static void registerRepository(ViewCachedRepository<?, ?> repo,
			Class<?> entityType) {
		if (viewCacheUpdateMessageConsumer != null) {
			viewCacheUpdateMessageConsumer.registerRepository(repo, entityType);
		}
	}

	public static void start(ProcessMessageReceiver receiver) {
		viewCacheUpdateMessageConsumer = new ViewCacheUpdateMessageConsumer(
				receiver);
		viewCacheUpdateMessageConsumer.start();
	}
}
