package com.bots.ctrl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.bots.aggr.UseCase;
import com.bots.service.TaskService;

@RestController
@RequestMapping("/task")
public class TaskController {

	@Autowired
	private TaskService taskService;

	@RequestMapping("/createtasks")
	@ResponseBody
	public VO createTaskForUsers(long userIdFrom, long usersCount,
			String taskTpl, String taskInputs) {
		Object[] taskInputsArray = null;
		if (taskInputs != null) {
			String[] taskInputsStrArray = taskInputs.split("\\|");
			taskInputsArray = new Object[taskInputsStrArray.length];
			for (int i = 0; i < taskInputsStrArray.length; i++) {
				taskInputsArray[i] = taskInputsStrArray[i];
			}
		}
		for (long i = 0; i < usersCount; i++) {
			try {
				taskService.createTaskForUser(taskTpl, userIdFrom + i,
						taskInputsArray);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return VO.success();
	}

	@RequestMapping("/starttasks")
	@ResponseBody
	public VO startTasks(long userIdFrom, long usersCount) {
		for (long i = 0; i < usersCount; i++) {
			taskService.userStartTask(userIdFrom + i);
		}
		return VO.success();
	}

	@RequestMapping("/usersession")
	@ResponseBody
	public VO usersession(long userId, int caseIdx) {
		UseCase useCase = taskService.queryUseCase(userId, caseIdx);
		if (useCase == null) {
			return VO.unsuccess("usersession not found");
		}
		return VO.success(useCase.getUserSession());
	}

	@RequestMapping("/clear")
	@ResponseBody
	public VO clear() {
		taskService.clear();
		return VO.success();
	}

	@RequestMapping("/stationsstarttasks")
	@ResponseBody
	public VO startTasks(long userIdFrom, long usersCount, int stationsCount) {
		taskService.userStartTaskWithStations(userIdFrom, usersCount,
				stationsCount);
		return VO.success();
	}

}
