/*
 * Decompiled with CFR 0.152.
 */
package com.bots.ctrl;

import com.bots.aggr.UseCase;
import com.bots.ctrl.VO;
import com.bots.service.TaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class TaskController {
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"/createtasks"})
    @ResponseBody
    public VO createTaskForUsers(long userIdFrom, long usersCount, String taskTpl, String taskInputs) {
        Object[] taskInputsArray = null;
        if (taskInputs != null) {
            String[] taskInputsStrArray = taskInputs.split("\\|");
            taskInputsArray = new Object[taskInputsStrArray.length];
            for (int i = 0; i < taskInputsStrArray.length; ++i) {
                taskInputsArray[i] = taskInputsStrArray[i];
            }
        }
        for (long i = 0L; i < usersCount; ++i) {
            try {
                this.taskService.createTaskForUser(taskTpl, userIdFrom + i, taskInputsArray);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return VO.success();
    }

    @RequestMapping(value={"/starttasks"})
    @ResponseBody
    public VO startTasks(long userIdFrom, long usersCount) {
        for (long i = 0L; i < usersCount; ++i) {
            this.taskService.userStartTask(userIdFrom + i);
        }
        return VO.success();
    }

    @RequestMapping(value={"/usersession"})
    @ResponseBody
    public VO usersession(long userId, int caseIdx) {
        UseCase useCase = this.taskService.queryUseCase(userId, caseIdx);
        if (useCase == null) {
            return VO.unsuccess("usersession not found");
        }
        return VO.success(useCase.getUserSession());
    }

    @RequestMapping(value={"/clear"})
    @ResponseBody
    public VO clear() {
        this.taskService.clear();
        return VO.success();
    }

    @RequestMapping(value={"/stationsstarttasks"})
    @ResponseBody
    public VO startTasks(long userIdFrom, long usersCount, int stationsCount) {
        this.taskService.userStartTaskWithStations(userIdFrom, usersCount, stationsCount);
        return VO.success();
    }
}

