/*
 * Decompiled with CFR 0.152.
 */
package com.bots.service;

import arp.process.Process;
import arp.repository.CommonMemRepository;
import com.bots.aggr.TaskTemplate;
import com.bots.aggr.UseCase;
import com.bots.aggr.UserTask;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableScheduling
public class TaskService {
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private CommonMemRepository<UserTask> userTaskRepository = new CommonMemRepository(UserTask.class);

    @Process
    public void createTaskForUser(String taskTemplateType, long userId, Object ... taskInputs) throws Exception {
        TaskTemplate taskTemplate = (TaskTemplate)Class.forName(taskTemplateType).newInstance();
        UserTask userTask = new UserTask(userId, taskTemplate.createTask(userId, taskInputs));
        this.userTaskRepository.save((Object)userTask);
    }

    public void userStartTask(long userId) {
        this.executorService.submit(() -> this.startTask(userId));
    }

    @Process
    public void startTask(long userId) {
        UserTask userTask = (UserTask)this.userTaskRepository.findByIdForUpdate((Object)userId);
        if (userTask == null) {
            return;
        }
        userTask.getTask().start();
    }

    @Process
    public UseCase queryUseCase(long userId, int caseIdx) {
        UserTask userTask = (UserTask)this.userTaskRepository.findById((Object)userId);
        if (userTask == null) {
            return null;
        }
        return userTask.getTask().getCase(caseIdx);
    }

    public void clear() {
        this.userTaskRepository.deleteEntities(this.userTaskRepository.idSet());
    }

    public void userStartTaskWithStations(long userIdFrom, long usersCount, int stationsCount) {
        if ((long)stationsCount > usersCount) {
            stationsCount = (int)usersCount;
        }
        Queue[] stationUserIds = new Queue[stationsCount];
        for (int i = 0; i < stationsCount; ++i) {
            stationUserIds[i] = new LinkedList();
        }
        for (long i = 0L; i < usersCount; ++i) {
            int stationIdx = (int)(i % (long)stationsCount);
            stationUserIds[stationIdx].add(userIdFrom + i);
        }
        for (Queue userIds : stationUserIds) {
            this.executorService.submit(() -> {
                for (Long userId : userIds) {
                    this.startTask(userId);
                    while (!this.checkTaskFinished(userId)) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Process
    public boolean checkTaskFinished(long userId) {
        UserTask userTask = (UserTask)this.userTaskRepository.findById((Object)userId);
        if (userTask == null) {
            return true;
        }
        return userTask.getTask().isFinished();
    }
}

