/*
 * Decompiled with CFR 0.152.
 */
package com.bots.http;

import com.bots.aggr.UserSession;
import com.bots.http.ExchangeStatistic;
import com.bots.util.CurrentTimeMillisClock;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;

public abstract class HttpExchange {
    private static CurrentTimeMillisClock clock = CurrentTimeMillisClock.getInstance();
    private static Map<Long, ExchangeStatistic> statistic = new ConcurrentHashMap<Long, ExchangeStatistic>();
    private static AtomicLong statisticIds = new AtomicLong();

    public static void clearStatistic() {
        statistic.clear();
        statisticIds.set(0L);
    }

    public static int countExchanges() {
        return statistic.size();
    }

    public void send(HttpClient httpClient, UserSession userSession, Object ... parameters) {
        ExchangeStatistic sta = new ExchangeStatistic(statisticIds.incrementAndGet());
        Request request = this.getRequest(httpClient, userSession, parameters);
        sta.setReqPath(request.getPath());
        ContentResponse response = null;
        try {
            sta.setStart(clock.now());
            response = request.send();
            sta.setFinish(clock.now());
            sta.calculateDuringTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.processResponse(response, userSession, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.getClass().getSimpleName() + " processResponse error: response=" + response == null ? "null" : response.getContentAsString());
        }
        statistic.put(sta.getId(), sta);
        if (userSession != null) {
            ArrayList<ExchangeStatistic> httpExchStatList = (ArrayList<ExchangeStatistic>)userSession.getObject("httpExchStatList");
            if (httpExchStatList == null) {
                httpExchStatList = new ArrayList<ExchangeStatistic>();
                userSession.putObject("httpExchStatList", httpExchStatList);
            }
            httpExchStatList.add(sta);
        }
    }

    protected abstract void processResponse(ContentResponse var1, UserSession var2, Object ... var3);

    protected abstract Request getRequest(HttpClient var1, UserSession var2, Object ... var3);
}

