/*
 * Decompiled with CFR 0.152.
 */
package com.bots.service;

import arp.process.Process;
import arp.repository.CommonMemRepository;
import arp.repository.SingleEntityRepository;
import com.bots.aggr.TaskTemplate;
import com.bots.aggr.Tasks;
import com.bots.aggr.UseCase;
import com.bots.aggr.UserTask;
import com.bots.http.HttpExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableScheduling
public class TaskService {
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private CommonMemRepository<UserTask> userTaskRepository = new CommonMemRepository(UserTask.class);
    private SingleEntityRepository<Tasks> tasksRepository = new SingleEntityRepository();

    @Process
    public void createTaskForUser(TaskTemplate taskTemplate, long userId, Object ... taskInputs) throws Exception {
        UserTask userTask = new UserTask(userId, taskTemplate.createTask(userId, taskInputs));
        this.userTaskRepository.save((Object)userTask);
    }

    public void userStartTask(long userId) {
        this.executorService.submit(() -> this.startTask(userId));
    }

    @Process
    public void startTask(long userId) {
        UserTask userTask = (UserTask)this.userTaskRepository.findByIdForUpdate((Object)userId);
        if (userTask == null) {
            return;
        }
        userTask.getTask().start();
    }

    @Process
    public UseCase queryUseCase(long userId, int caseIdx) {
        UserTask userTask = (UserTask)this.userTaskRepository.findById((Object)userId);
        if (userTask == null) {
            return null;
        }
        return userTask.getTask().getCase(caseIdx);
    }

    public void clear() {
        this.userTaskRepository.deleteEntities(this.userTaskRepository.idSet());
        this.tasksRepository.put(null);
    }

    public void userStartTaskWithStations(long userIdFrom, long usersCount, int stationsCount) {
        if ((long)stationsCount > usersCount) {
            stationsCount = (int)usersCount;
        }
        Queue[] stationUserIds = new Queue[stationsCount];
        for (int i = 0; i < stationsCount; ++i) {
            stationUserIds[i] = new LinkedList();
        }
        for (long i = 0L; i < usersCount; ++i) {
            int stationIdx = (int)(i % (long)stationsCount);
            stationUserIds[stationIdx].add(userIdFrom + i);
        }
        this.recordStartTasks(stationsCount);
        for (Queue userIds : stationUserIds) {
            this.executorService.submit(() -> {
                for (Long userId : userIds) {
                    this.startTask(userId);
                    while (!this.checkTaskFinished(userId)) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.updateTasksByStationFinished();
            });
        }
    }

    @Process
    public void updateTasksByStationFinished() {
        Tasks tasks = (Tasks)this.tasksRepository.getForUpdate();
        tasks.stationFinished(System.currentTimeMillis());
    }

    @Process
    public void recordStartTasks(int stationsCount) {
        Tasks tasks = new Tasks();
        tasks.setStationsCount(stationsCount);
        tasks.setStart(System.currentTimeMillis());
        this.tasksRepository.put((Object)tasks);
    }

    @Process
    public boolean checkTaskFinished(long userId) {
        UserTask userTask = (UserTask)this.userTaskRepository.findById((Object)userId);
        if (userTask == null) {
            return true;
        }
        return userTask.getTask().isFinished();
    }

    @Process
    public Map httpStat() {
        HashMap<String, Number> stat = new HashMap<String, Number>();
        Tasks tasks = (Tasks)this.tasksRepository.get();
        long startTime = tasks.getStart();
        long statTime = System.currentTimeMillis();
        if (tasks.getFinish() > 0L) {
            statTime = tasks.getFinish();
        }
        long httpExchangesCount = HttpExchange.countExchanges();
        double s = (double)(statTime - startTime) / 1000.0;
        double qpsd = (double)httpExchangesCount / s;
        stat.put("startTime", startTime);
        stat.put("statTime", statTime);
        stat.put("httpExchangesCount", httpExchangesCount);
        stat.put("QPS", (int)qpsd);
        return stat;
    }

    @Process
    public List<UserTask> queryUserTasks(long userIdFrom, long usersCount) {
        ArrayList<UserTask> list = new ArrayList<UserTask>();
        for (long i = 0L; i < usersCount; ++i) {
            UserTask userTask = (UserTask)this.userTaskRepository.findById((Object)(userIdFrom + i));
            if (userTask == null) continue;
            list.add(userTask);
        }
        return list;
    }
}

